/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class NetUtils {
    private static final Log LOG = LogFactory.getLog(NetUtils.class);
    private final NetProperties netProperties;

    public NetUtils(NetProperties netProperties) {
        this.netProperties = netProperties;
    }

    public InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || this.ignoreInterface(networkInterface.getDisplayName())) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || !this.isPreferredAddress(address)) continue;
                    result = address;
                }
            }
        }
        catch (IOException exception) {
            LOG.error("Cannot get first non-loopback address", (Throwable)exception);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to retrieve localhost");
        }
    }

    boolean isPreferredAddress(InetAddress address) {
        List<String> preferredNetworks = this.netProperties.getPreferredNetworks();
        if (preferredNetworks.isEmpty()) {
            return true;
        }
        for (String regex : preferredNetworks) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        return false;
    }

    boolean ignoreInterface(String interfaceName) {
        List<String> ignoredInterfaces = this.netProperties.getIgnoredInterfaces();
        for (String regex : ignoredInterfaces) {
            if (!interfaceName.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static class NetProperties {
        private List<String> preferredNetworks = new ArrayList<String>();
        private List<String> ignoredInterfaces = new ArrayList<String>();

        public List<String> getPreferredNetworks() {
            return this.preferredNetworks;
        }

        public List<String> getIgnoredInterfaces() {
            return this.ignoredInterfaces;
        }

        public void setPreferredNetworks(List<String> preferredNetworks) {
            this.preferredNetworks = preferredNetworks;
        }

        public void setIgnoredInterfaces(List<String> ignoredInterfaces) {
            this.ignoredInterfaces = ignoredInterfaces;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetProperties)) {
                return false;
            }
            NetProperties other = (NetProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$preferredNetworks = this.getPreferredNetworks();
            List<String> other$preferredNetworks = other.getPreferredNetworks();
            if (this$preferredNetworks == null ? other$preferredNetworks != null : !((Object)this$preferredNetworks).equals(other$preferredNetworks)) {
                return false;
            }
            List<String> this$ignoredInterfaces = this.getIgnoredInterfaces();
            List<String> other$ignoredInterfaces = other.getIgnoredInterfaces();
            return !(this$ignoredInterfaces == null ? other$ignoredInterfaces != null : !((Object)this$ignoredInterfaces).equals(other$ignoredInterfaces));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NetProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $preferredNetworks = this.getPreferredNetworks();
            result = result * 59 + ($preferredNetworks == null ? 43 : ((Object)$preferredNetworks).hashCode());
            List<String> $ignoredInterfaces = this.getIgnoredInterfaces();
            result = result * 59 + ($ignoredInterfaces == null ? 43 : ((Object)$ignoredInterfaces).hashCode());
            return result;
        }

        public String toString() {
            return "NetUtils.NetProperties(preferredNetworks=" + this.getPreferredNetworks() + ", ignoredInterfaces=" + this.getIgnoredInterfaces() + ")";
        }

        public NetProperties() {
        }

        public NetProperties(List<String> preferredNetworks, List<String> ignoredInterfaces) {
            this.preferredNetworks = preferredNetworks;
            this.ignoredInterfaces = ignoredInterfaces;
        }
    }
}

