/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.MybatisMapperAnnotationBuilder;
import com.baomidou.mybatisplus.core.override.MybatisMapperProxyFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class MybatisMapperRegistry
extends MapperRegistry {
    private final Configuration config;
    private final Map<Class<?>, MybatisMapperProxyFactory<?>> knownMappers = new HashMap();

    public MybatisMapperRegistry(Configuration config) {
        super(config);
        this.config = config;
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        MybatisMapperProxyFactory mapperProxyFactory = this.knownMappers.get(type);
        if (mapperProxyFactory == null) {
            mapperProxyFactory = (MybatisMapperProxyFactory)((Object)this.knownMappers.entrySet().stream().filter(t -> ((Class)t.getKey()).getName().equals(type.getName())).findFirst().orElseThrow(() -> new BindingException("Type " + type + " is not known to the MybatisPlusMapperRegistry.")));
        }
        try {
            return (T)mapperProxyFactory.newInstance(sqlSession);
        }
        catch (Exception e) {
            throw new BindingException("Error getting mapper instance. Cause: " + e, (Throwable)e);
        }
    }

    public <T> boolean hasMapper(Class<T> type) {
        return this.knownMappers.containsKey(type);
    }

    protected <T> void removeMapper(Class<T> type) {
        this.knownMappers.entrySet().stream().filter(t -> ((Class)t.getKey()).getName().equals(type.getName())).findFirst().ifPresent(t -> this.knownMappers.remove(t.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addMapper(Class<T> type) {
        if (type.isInterface()) {
            if (this.hasMapper(type)) {
                return;
            }
            boolean loadCompleted = false;
            try {
                this.knownMappers.put(type, new MybatisMapperProxyFactory<T>(type));
                MybatisMapperAnnotationBuilder parser = new MybatisMapperAnnotationBuilder(this.config, type);
                parser.parse();
                loadCompleted = true;
            }
            finally {
                if (!loadCompleted) {
                    this.knownMappers.remove(type);
                }
            }
        }
    }

    public Collection<Class<?>> getMappers() {
        return Collections.unmodifiableCollection(this.knownMappers.keySet());
    }
}

