/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis-plus")
public class MybatisPlusProperties {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String configLocation;
    private String[] mapperLocations = new String[]{"classpath*:/mapper/**/*.xml"};
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private MybatisConfiguration configuration;
    @Deprecated
    private String typeEnumsPackage;
    @NestedConfigurationProperty
    private GlobalConfig globalConfig = GlobalConfigUtils.defaults();

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of(Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
        return this.defaultScriptingLanguageDriver;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public MybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public String getTypeEnumsPackage() {
        return this.typeEnumsPackage;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public MybatisPlusProperties setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public MybatisPlusProperties setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
        return this;
    }

    public MybatisPlusProperties setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
        return this;
    }

    public MybatisPlusProperties setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
        return this;
    }

    public MybatisPlusProperties setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
        return this;
    }

    public MybatisPlusProperties setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
        return this;
    }

    public MybatisPlusProperties setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
        return this;
    }

    public MybatisPlusProperties setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
        this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
        return this;
    }

    public MybatisPlusProperties setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        return this;
    }

    public MybatisPlusProperties setConfiguration(MybatisConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Deprecated
    public MybatisPlusProperties setTypeEnumsPackage(String typeEnumsPackage) {
        this.typeEnumsPackage = typeEnumsPackage;
        return this;
    }

    public MybatisPlusProperties setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MybatisPlusProperties)) {
            return false;
        }
        MybatisPlusProperties other = (MybatisPlusProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckConfigLocation() != other.isCheckConfigLocation()) {
            return false;
        }
        String this$configLocation = this.getConfigLocation();
        String other$configLocation = other.getConfigLocation();
        if (this$configLocation == null ? other$configLocation != null : !this$configLocation.equals(other$configLocation)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMapperLocations(), other.getMapperLocations())) {
            return false;
        }
        String this$typeAliasesPackage = this.getTypeAliasesPackage();
        String other$typeAliasesPackage = other.getTypeAliasesPackage();
        if (this$typeAliasesPackage == null ? other$typeAliasesPackage != null : !this$typeAliasesPackage.equals(other$typeAliasesPackage)) {
            return false;
        }
        Class<?> this$typeAliasesSuperType = this.getTypeAliasesSuperType();
        Class<?> other$typeAliasesSuperType = other.getTypeAliasesSuperType();
        if (this$typeAliasesSuperType == null ? other$typeAliasesSuperType != null : !this$typeAliasesSuperType.equals(other$typeAliasesSuperType)) {
            return false;
        }
        String this$typeHandlersPackage = this.getTypeHandlersPackage();
        String other$typeHandlersPackage = other.getTypeHandlersPackage();
        if (this$typeHandlersPackage == null ? other$typeHandlersPackage != null : !this$typeHandlersPackage.equals(other$typeHandlersPackage)) {
            return false;
        }
        ExecutorType this$executorType = this.getExecutorType();
        ExecutorType other$executorType = other.getExecutorType();
        if (this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType)) {
            return false;
        }
        Class<? extends LanguageDriver> this$defaultScriptingLanguageDriver = this.getDefaultScriptingLanguageDriver();
        Class<? extends LanguageDriver> other$defaultScriptingLanguageDriver = other.getDefaultScriptingLanguageDriver();
        if (this$defaultScriptingLanguageDriver == null ? other$defaultScriptingLanguageDriver != null : !this$defaultScriptingLanguageDriver.equals(other$defaultScriptingLanguageDriver)) {
            return false;
        }
        Properties this$configurationProperties = this.getConfigurationProperties();
        Properties other$configurationProperties = other.getConfigurationProperties();
        if (this$configurationProperties == null ? other$configurationProperties != null : !((Object)this$configurationProperties).equals(other$configurationProperties)) {
            return false;
        }
        MybatisConfiguration this$configuration = this.getConfiguration();
        MybatisConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$typeEnumsPackage = this.getTypeEnumsPackage();
        String other$typeEnumsPackage = other.getTypeEnumsPackage();
        if (this$typeEnumsPackage == null ? other$typeEnumsPackage != null : !this$typeEnumsPackage.equals(other$typeEnumsPackage)) {
            return false;
        }
        GlobalConfig this$globalConfig = this.getGlobalConfig();
        GlobalConfig other$globalConfig = other.getGlobalConfig();
        return !(this$globalConfig == null ? other$globalConfig != null : !this$globalConfig.equals(other$globalConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MybatisPlusProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckConfigLocation() ? 79 : 97);
        String $configLocation = this.getConfigLocation();
        result = result * 59 + ($configLocation == null ? 43 : $configLocation.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMapperLocations());
        String $typeAliasesPackage = this.getTypeAliasesPackage();
        result = result * 59 + ($typeAliasesPackage == null ? 43 : $typeAliasesPackage.hashCode());
        Class<?> $typeAliasesSuperType = this.getTypeAliasesSuperType();
        result = result * 59 + ($typeAliasesSuperType == null ? 43 : $typeAliasesSuperType.hashCode());
        String $typeHandlersPackage = this.getTypeHandlersPackage();
        result = result * 59 + ($typeHandlersPackage == null ? 43 : $typeHandlersPackage.hashCode());
        ExecutorType $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        Class<? extends LanguageDriver> $defaultScriptingLanguageDriver = this.getDefaultScriptingLanguageDriver();
        result = result * 59 + ($defaultScriptingLanguageDriver == null ? 43 : $defaultScriptingLanguageDriver.hashCode());
        Properties $configurationProperties = this.getConfigurationProperties();
        result = result * 59 + ($configurationProperties == null ? 43 : ((Object)$configurationProperties).hashCode());
        MybatisConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $typeEnumsPackage = this.getTypeEnumsPackage();
        result = result * 59 + ($typeEnumsPackage == null ? 43 : $typeEnumsPackage.hashCode());
        GlobalConfig $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : $globalConfig.hashCode());
        return result;
    }

    public String toString() {
        return "MybatisPlusProperties(configLocation=" + this.getConfigLocation() + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", typeAliasesSuperType=" + this.getTypeAliasesSuperType() + ", typeHandlersPackage=" + this.getTypeHandlersPackage() + ", checkConfigLocation=" + this.isCheckConfigLocation() + ", executorType=" + this.getExecutorType() + ", defaultScriptingLanguageDriver=" + this.getDefaultScriptingLanguageDriver() + ", configurationProperties=" + this.getConfigurationProperties() + ", configuration=" + this.getConfiguration() + ", typeEnumsPackage=" + this.getTypeEnumsPackage() + ", globalConfig=" + this.getGlobalConfig() + ")";
    }
}

