/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.logging.CommonsLogFilter;
import com.alibaba.druid.filter.logging.Log4j2Filter;
import com.alibaba.druid.filter.logging.Log4jFilter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.dynamic.datasource.creator.AbstractDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.exception.ErrorCreateDataSourceException;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidLogConfigUtil;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidStatConfigUtil;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidWallConfigUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class DruidDataSourceCreator
extends AbstractDataSourceCreator
implements DataSourceCreator,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceCreator.class);
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    private DruidConfig gConfig;

    @Override
    public DataSource doCreateDataSource(DataSourceProperty dataSourceProperty) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        dataSource.setName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            dataSource.setDriverClassName(driverClassName);
        }
        DruidConfig config = dataSourceProperty.getDruid();
        Properties properties = config.toProperties(this.gConfig);
        List<Filter> proxyFilters = this.initFilters(dataSourceProperty, properties.getProperty("druid.filters"));
        dataSource.setProxyFilters(proxyFilters);
        dataSource.configFromPropety(properties);
        dataSource.setConnectProperties(config.getConnectionProperties());
        this.setParam(dataSource, config);
        if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
            try {
                dataSource.init();
            }
            catch (SQLException e) {
                throw new ErrorCreateDataSourceException("druid create error", e);
            }
        }
        return dataSource;
    }

    private List<Filter> initFilters(DataSourceProperty dataSourceProperty, String filters) {
        ArrayList<Filter> proxyFilters = new ArrayList<Filter>(2);
        if (!StringUtils.isEmpty((Object)filters)) {
            String[] filterItems;
            String[] stringArray = filterItems = filters.split(",");
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String filter;
                switch (filter = stringArray[i]) {
                    case "stat": {
                        proxyFilters.add((Filter)DruidStatConfigUtil.toStatFilter(dataSourceProperty.getDruid().getStat(), this.gConfig.getStat()));
                        continue block16;
                    }
                    case "wall": {
                        WallConfig wallConfig = DruidWallConfigUtil.toWallConfig(dataSourceProperty.getDruid().getWall(), this.gConfig.getWall());
                        WallFilter wallFilter = new WallFilter();
                        wallFilter.setConfig(wallConfig);
                        proxyFilters.add((Filter)wallFilter);
                        continue block16;
                    }
                    case "slf4j": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(Slf4jLogFilter.class, dataSourceProperty.getDruid().getSlf4j(), this.gConfig.getSlf4j()));
                        continue block16;
                    }
                    case "commons-log": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(CommonsLogFilter.class, dataSourceProperty.getDruid().getCommonsLog(), this.gConfig.getCommonsLog()));
                        continue block16;
                    }
                    case "log4j": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(Log4jFilter.class, dataSourceProperty.getDruid().getLog4j(), this.gConfig.getLog4j()));
                        continue block16;
                    }
                    case "log4j2": {
                        proxyFilters.add((Filter)DruidLogConfigUtil.initFilter(Log4j2Filter.class, dataSourceProperty.getDruid().getLog4j2(), this.gConfig.getLog4j2()));
                        continue block16;
                    }
                    default: {
                        log.warn("dynamic-datasource current not support [{}]", (Object)filter);
                    }
                }
            }
        }
        if (this.applicationContext != null) {
            for (String filterId : this.gConfig.getProxyFilters()) {
                proxyFilters.add((Filter)this.applicationContext.getBean(filterId, Filter.class));
            }
        }
        return proxyFilters;
    }

    private void setParam(DruidDataSource dataSource, DruidConfig config) {
        Integer socketTimeout;
        Integer connectTimeout;
        Integer transactionQueryTimeout;
        Integer queryTimeOut;
        Boolean logAbandoned;
        Boolean abandoned;
        Integer timeout;
        Boolean breakAfterAcquireFailure;
        Integer connectionErrorRetryAttempts;
        Boolean sharePreparedStatements;
        Integer validationQueryTimeout;
        Boolean testOnReturn;
        Integer defaultTransactionIsolation;
        Boolean defaultReadOnly;
        Boolean defaultAutoCommit;
        String defaultCatalog;
        String string = defaultCatalog = config.getDefaultCatalog() == null ? this.gConfig.getDefaultCatalog() : config.getDefaultCatalog();
        if (defaultCatalog != null) {
            dataSource.setDefaultCatalog(defaultCatalog);
        }
        Boolean bl = defaultAutoCommit = config.getDefaultAutoCommit() == null ? this.gConfig.getDefaultAutoCommit() : config.getDefaultAutoCommit();
        if (defaultAutoCommit != null && !defaultAutoCommit.booleanValue()) {
            dataSource.setDefaultAutoCommit(false);
        }
        Boolean bl2 = defaultReadOnly = config.getDefaultReadOnly() == null ? this.gConfig.getDefaultReadOnly() : config.getDefaultReadOnly();
        if (defaultReadOnly != null) {
            dataSource.setDefaultReadOnly(defaultReadOnly);
        }
        Integer n = defaultTransactionIsolation = config.getDefaultTransactionIsolation() == null ? this.gConfig.getDefaultTransactionIsolation() : config.getDefaultTransactionIsolation();
        if (defaultTransactionIsolation != null) {
            dataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
        }
        Boolean bl3 = testOnReturn = config.getTestOnReturn() == null ? this.gConfig.getTestOnReturn() : config.getTestOnReturn();
        if (testOnReturn != null && testOnReturn.booleanValue()) {
            dataSource.setTestOnReturn(true);
        }
        Integer n2 = validationQueryTimeout = config.getValidationQueryTimeout() == null ? this.gConfig.getValidationQueryTimeout() : config.getValidationQueryTimeout();
        if (validationQueryTimeout != null && !validationQueryTimeout.equals(-1)) {
            dataSource.setValidationQueryTimeout(validationQueryTimeout.intValue());
        }
        Boolean bl4 = sharePreparedStatements = config.getSharePreparedStatements() == null ? this.gConfig.getSharePreparedStatements() : config.getSharePreparedStatements();
        if (sharePreparedStatements != null && sharePreparedStatements.booleanValue()) {
            dataSource.setSharePreparedStatements(true);
        }
        Integer n3 = connectionErrorRetryAttempts = config.getConnectionErrorRetryAttempts() == null ? this.gConfig.getConnectionErrorRetryAttempts() : config.getConnectionErrorRetryAttempts();
        if (connectionErrorRetryAttempts != null && !connectionErrorRetryAttempts.equals(1)) {
            dataSource.setConnectionErrorRetryAttempts(connectionErrorRetryAttempts.intValue());
        }
        Boolean bl5 = breakAfterAcquireFailure = config.getBreakAfterAcquireFailure() == null ? this.gConfig.getBreakAfterAcquireFailure() : config.getBreakAfterAcquireFailure();
        if (breakAfterAcquireFailure != null && breakAfterAcquireFailure.booleanValue()) {
            dataSource.setBreakAfterAcquireFailure(true);
        }
        Integer n4 = timeout = config.getRemoveAbandonedTimeoutMillis() == null ? this.gConfig.getRemoveAbandonedTimeoutMillis() : config.getRemoveAbandonedTimeoutMillis();
        if (timeout != null) {
            dataSource.setRemoveAbandonedTimeoutMillis((long)timeout.intValue());
        }
        Boolean bl6 = abandoned = config.getRemoveAbandoned() == null ? this.gConfig.getRemoveAbandoned() : config.getRemoveAbandoned();
        if (abandoned != null) {
            dataSource.setRemoveAbandoned(abandoned.booleanValue());
        }
        Boolean bl7 = logAbandoned = config.getLogAbandoned() == null ? this.gConfig.getLogAbandoned() : config.getLogAbandoned();
        if (logAbandoned != null) {
            dataSource.setLogAbandoned(logAbandoned.booleanValue());
        }
        Integer n5 = queryTimeOut = config.getQueryTimeout() == null ? this.gConfig.getQueryTimeout() : config.getQueryTimeout();
        if (queryTimeOut != null) {
            dataSource.setQueryTimeout(queryTimeOut.intValue());
        }
        Integer n6 = transactionQueryTimeout = config.getTransactionQueryTimeout() == null ? this.gConfig.getTransactionQueryTimeout() : config.getTransactionQueryTimeout();
        if (transactionQueryTimeout != null) {
            dataSource.setTransactionQueryTimeout(transactionQueryTimeout.intValue());
        }
        Integer n7 = connectTimeout = config.getConnectTimeout() == null ? this.gConfig.getConnectTimeout() : config.getConnectTimeout();
        if (connectTimeout != null) {
            try {
                DruidDataSource.class.getMethod("setConnectTimeout", Integer.TYPE);
                dataSource.setConnectTimeout(connectTimeout.intValue());
            }
            catch (NoSuchMethodException e) {
                log.warn("druid current not support connectTimeout,please update druid 1.2.12 +");
            }
        }
        Integer n8 = socketTimeout = config.getSocketTimeout() == null ? this.gConfig.getSocketTimeout() : config.getSocketTimeout();
        if (socketTimeout != null) {
            try {
                DruidDataSource.class.getMethod("setSocketTimeout", Integer.TYPE);
                dataSource.setSocketTimeout(socketTimeout.intValue());
            }
            catch (NoSuchMethodException e) {
                log.warn("druid current not support setSocketTimeout,please update druid 1.2.12 +");
            }
        }
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null || "com.alibaba.druid.pool.DruidDataSource".equals(type.getName());
    }

    public void afterPropertiesSet() throws Exception {
        this.gConfig = this.properties.getDruid();
    }
}

