/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidSlf4jConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidStatConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.druid.DruidWallConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class DruidConfig {
    private static final Logger log = LoggerFactory.getLogger(DruidConfig.class);
    private Integer initialSize;
    private Integer maxActive;
    private Integer minIdle;
    private Integer maxWait;
    private Long timeBetweenEvictionRunsMillis;
    private Long timeBetweenLogStatsMillis;
    private Integer statSqlMaxSize;
    private Long minEvictableIdleTimeMillis;
    private Long maxEvictableIdleTimeMillis;
    private String defaultCatalog;
    private Boolean defaultAutoCommit;
    private Boolean defaultReadOnly;
    private Integer defaultTransactionIsolation;
    private Boolean testWhileIdle;
    private Boolean testOnBorrow;
    private Boolean testOnReturn;
    private String validationQuery;
    private Integer validationQueryTimeout;
    private Boolean useGlobalDataSourceStat;
    private Boolean asyncInit;
    private String filters;
    private Boolean clearFiltersEnable;
    private Boolean resetStatEnable;
    private Integer notFullTimeoutRetryCount;
    private Integer maxWaitThreadCount;
    private Boolean failFast;
    private Long phyTimeoutMillis;
    private Boolean keepAlive;
    private Boolean poolPreparedStatements;
    private Boolean initVariants;
    private Boolean initGlobalVariants;
    private Boolean useUnfairLock;
    private Boolean killWhenSocketReadTimeout;
    private Properties connectionProperties;
    private Integer maxPoolPreparedStatementPerConnectionSize;
    private String initConnectionSqls;
    private Boolean sharePreparedStatements;
    private Integer connectionErrorRetryAttempts;
    private Boolean breakAfterAcquireFailure;
    private Boolean removeAbandoned;
    private Integer removeAbandonedTimeoutMillis;
    private Boolean logAbandoned;
    private Integer queryTimeout;
    private Integer transactionQueryTimeout;
    private String publicKey;
    @NestedConfigurationProperty
    private DruidWallConfig wall = new DruidWallConfig();
    @NestedConfigurationProperty
    private DruidStatConfig stat = new DruidStatConfig();
    @NestedConfigurationProperty
    private DruidSlf4jConfig slf4j = new DruidSlf4jConfig();
    private List<String> proxyFilters = new ArrayList<String>();

    public Properties toProperties(DruidConfig g) {
        Boolean mergeSql;
        Long slowSqlMillis;
        Boolean logSlowSql;
        Integer statSqlMaxSize;
        String initConnectionSqls;
        Integer maxPoolPreparedStatementPerConnectionSize;
        Properties connectProperties;
        Boolean killWhenSocketReadTimeout;
        Boolean useUnfairLock;
        Boolean initGlobalVariants;
        Boolean initVariants;
        Boolean poolPreparedStatements;
        Boolean keepAlive;
        Long phyTimeoutMillis;
        Boolean failFast;
        Integer maxWaitThreadCount;
        Integer notFullTimeoutRetryCount;
        Boolean resetStatEnable;
        Boolean clearFiltersEnable;
        String filters;
        Boolean asyncInit;
        Boolean useGlobalDataSourceStat;
        String validationQuery;
        Boolean testOnBorrow;
        Boolean testWhileIdle;
        Long maxEvictableIdleTimeMillis;
        Long minEvictableIdleTimeMillis;
        Long timeBetweenLogStatsMillis;
        Long timeBetweenEvictionRunsMillis;
        Integer maxWait;
        Integer minIdle;
        Integer maxActive;
        Integer initialSize;
        Properties properties = new Properties();
        Integer n = initialSize = this.initialSize == null ? g.getInitialSize() : this.initialSize;
        if (initialSize != null && !initialSize.equals(0)) {
            properties.setProperty("druid.initialSize", String.valueOf(initialSize));
        }
        Integer n2 = maxActive = this.maxActive == null ? g.getMaxActive() : this.maxActive;
        if (maxActive != null && !maxActive.equals(-1)) {
            properties.setProperty("druid.maxActive", String.valueOf(maxActive));
        }
        Integer n3 = minIdle = this.minIdle == null ? g.getMinIdle() : this.minIdle;
        if (minIdle != null && !minIdle.equals(0)) {
            properties.setProperty("druid.minIdle", String.valueOf(minIdle));
        }
        Integer n4 = maxWait = this.maxWait == null ? g.getMaxWait() : this.maxWait;
        if (maxWait != null && !maxWait.equals(-1)) {
            properties.setProperty("druid.maxWait", String.valueOf(maxWait));
        }
        Long l = timeBetweenEvictionRunsMillis = this.timeBetweenEvictionRunsMillis == null ? g.getTimeBetweenEvictionRunsMillis() : this.timeBetweenEvictionRunsMillis;
        if (timeBetweenEvictionRunsMillis != null && !timeBetweenEvictionRunsMillis.equals(60000L)) {
            properties.setProperty("druid.timeBetweenEvictionRunsMillis", String.valueOf(timeBetweenEvictionRunsMillis));
        }
        Long l2 = timeBetweenLogStatsMillis = this.timeBetweenLogStatsMillis == null ? g.getTimeBetweenLogStatsMillis() : this.timeBetweenLogStatsMillis;
        if (timeBetweenLogStatsMillis != null && timeBetweenLogStatsMillis > 0L) {
            properties.setProperty("druid.timeBetweenLogStatsMillis", String.valueOf(timeBetweenLogStatsMillis));
        }
        Long l3 = minEvictableIdleTimeMillis = this.minEvictableIdleTimeMillis == null ? g.getMinEvictableIdleTimeMillis() : this.minEvictableIdleTimeMillis;
        if (minEvictableIdleTimeMillis != null && !minEvictableIdleTimeMillis.equals(1800000L)) {
            properties.setProperty("druid.minEvictableIdleTimeMillis", String.valueOf(minEvictableIdleTimeMillis));
        }
        Long l4 = maxEvictableIdleTimeMillis = this.maxEvictableIdleTimeMillis == null ? g.getMaxEvictableIdleTimeMillis() : this.maxEvictableIdleTimeMillis;
        if (maxEvictableIdleTimeMillis != null && !maxEvictableIdleTimeMillis.equals(25200000L)) {
            properties.setProperty("druid.maxEvictableIdleTimeMillis", String.valueOf(maxEvictableIdleTimeMillis));
        }
        Boolean bl = testWhileIdle = this.testWhileIdle == null ? g.getTestWhileIdle() : this.testWhileIdle;
        if (testWhileIdle != null && !testWhileIdle.equals(true)) {
            properties.setProperty("druid.testWhileIdle", "false");
        }
        Boolean bl2 = testOnBorrow = this.testOnBorrow == null ? g.getTestOnBorrow() : this.testOnBorrow;
        if (testOnBorrow != null && !testOnBorrow.equals(false)) {
            properties.setProperty("druid.testOnBorrow", "true");
        }
        String string = validationQuery = this.validationQuery == null ? g.getValidationQuery() : this.validationQuery;
        if (validationQuery != null && validationQuery.length() > 0) {
            properties.setProperty("druid.validationQuery", validationQuery);
        }
        Boolean bl3 = useGlobalDataSourceStat = this.useGlobalDataSourceStat == null ? g.getUseGlobalDataSourceStat() : this.useGlobalDataSourceStat;
        if (useGlobalDataSourceStat != null && useGlobalDataSourceStat.equals(Boolean.TRUE)) {
            properties.setProperty("druid.useGlobalDataSourceStat", "true");
        }
        Boolean bl4 = asyncInit = this.asyncInit == null ? g.getAsyncInit() : this.asyncInit;
        if (asyncInit != null && asyncInit.equals(Boolean.TRUE)) {
            properties.setProperty("druid.asyncInit", "true");
        }
        String string2 = filters = this.filters == null ? g.getFilters() : this.filters;
        if (filters == null) {
            filters = "stat";
        }
        if (this.publicKey != null && this.publicKey.length() > 0 && !filters.contains("config")) {
            filters = filters + ",config";
        }
        properties.setProperty("druid.filters", filters);
        Boolean bl5 = clearFiltersEnable = this.clearFiltersEnable == null ? g.getClearFiltersEnable() : this.clearFiltersEnable;
        if (clearFiltersEnable != null && clearFiltersEnable.equals(Boolean.FALSE)) {
            properties.setProperty("druid.clearFiltersEnable", "false");
        }
        Boolean bl6 = resetStatEnable = this.resetStatEnable == null ? g.getResetStatEnable() : this.resetStatEnable;
        if (resetStatEnable != null && resetStatEnable.equals(Boolean.FALSE)) {
            properties.setProperty("druid.resetStatEnable", "false");
        }
        Integer n5 = notFullTimeoutRetryCount = this.notFullTimeoutRetryCount == null ? g.getNotFullTimeoutRetryCount() : this.notFullTimeoutRetryCount;
        if (notFullTimeoutRetryCount != null && !notFullTimeoutRetryCount.equals(0)) {
            properties.setProperty("druid.notFullTimeoutRetryCount", String.valueOf(notFullTimeoutRetryCount));
        }
        Integer n6 = maxWaitThreadCount = this.maxWaitThreadCount == null ? g.getMaxWaitThreadCount() : this.maxWaitThreadCount;
        if (maxWaitThreadCount != null && !maxWaitThreadCount.equals(-1)) {
            properties.setProperty("druid.maxWaitThreadCount", String.valueOf(maxWaitThreadCount));
        }
        Boolean bl7 = failFast = this.failFast == null ? g.getFailFast() : this.failFast;
        if (failFast != null && failFast.equals(Boolean.TRUE)) {
            properties.setProperty("druid.failFast", "true");
        }
        Long l5 = phyTimeoutMillis = this.phyTimeoutMillis == null ? g.getPhyTimeoutMillis() : this.phyTimeoutMillis;
        if (phyTimeoutMillis != null && !phyTimeoutMillis.equals(-1L)) {
            properties.setProperty("druid.phyTimeoutMillis", String.valueOf(phyTimeoutMillis));
        }
        Boolean bl8 = keepAlive = this.keepAlive == null ? g.getKeepAlive() : this.keepAlive;
        if (keepAlive != null && keepAlive.equals(Boolean.TRUE)) {
            properties.setProperty("druid.keepAlive", "true");
        }
        Boolean bl9 = poolPreparedStatements = this.poolPreparedStatements == null ? g.getPoolPreparedStatements() : this.poolPreparedStatements;
        if (poolPreparedStatements != null && poolPreparedStatements.equals(Boolean.TRUE)) {
            properties.setProperty("druid.poolPreparedStatements", "true");
        }
        Boolean bl10 = initVariants = this.initVariants == null ? g.getInitVariants() : this.initVariants;
        if (initVariants != null && initVariants.equals(Boolean.TRUE)) {
            properties.setProperty("druid.initVariants", "true");
        }
        Boolean bl11 = initGlobalVariants = this.initGlobalVariants == null ? g.getInitGlobalVariants() : this.initGlobalVariants;
        if (initGlobalVariants != null && initGlobalVariants.equals(Boolean.TRUE)) {
            properties.setProperty("druid.initGlobalVariants", "true");
        }
        Boolean bl12 = useUnfairLock = this.useUnfairLock == null ? g.getUseUnfairLock() : this.useUnfairLock;
        if (useUnfairLock != null) {
            properties.setProperty("druid.useUnfairLock", String.valueOf(useUnfairLock));
        }
        Boolean bl13 = killWhenSocketReadTimeout = this.killWhenSocketReadTimeout == null ? g.getKillWhenSocketReadTimeout() : this.killWhenSocketReadTimeout;
        if (killWhenSocketReadTimeout != null && killWhenSocketReadTimeout.equals(Boolean.TRUE)) {
            properties.setProperty("druid.killWhenSocketReadTimeout", "true");
        }
        Properties properties2 = connectProperties = this.connectionProperties == null ? g.getConnectionProperties() : this.connectionProperties;
        if (this.publicKey != null && this.publicKey.length() > 0) {
            if (connectProperties == null) {
                connectProperties = new Properties();
            }
            log.info("dynamic-datasource detect druid publicKey,It is highly recommended that you use the built-in encryption method \n https://dynamic-datasource.com/guide/advance/Encode.html");
            connectProperties.setProperty("config.decrypt", "true");
            connectProperties.setProperty("config.decrypt.key", this.publicKey);
        }
        this.connectionProperties = connectProperties;
        Integer n7 = maxPoolPreparedStatementPerConnectionSize = this.maxPoolPreparedStatementPerConnectionSize == null ? g.getMaxPoolPreparedStatementPerConnectionSize() : this.maxPoolPreparedStatementPerConnectionSize;
        if (maxPoolPreparedStatementPerConnectionSize != null && !maxPoolPreparedStatementPerConnectionSize.equals(10)) {
            properties.setProperty("druid.maxPoolPreparedStatementPerConnectionSize", String.valueOf(maxPoolPreparedStatementPerConnectionSize));
        }
        String string3 = initConnectionSqls = this.initConnectionSqls == null ? g.getInitConnectionSqls() : this.initConnectionSqls;
        if (initConnectionSqls != null && initConnectionSqls.length() > 0) {
            properties.setProperty("druid.initConnectionSqls", initConnectionSqls);
        }
        Integer n8 = statSqlMaxSize = this.statSqlMaxSize == null ? g.getStatSqlMaxSize() : this.statSqlMaxSize;
        if (statSqlMaxSize != null) {
            properties.setProperty("druid.stat.sql.MaxSize", String.valueOf(statSqlMaxSize));
        }
        Boolean bl14 = logSlowSql = this.stat.getLogSlowSql() == null ? g.stat.getLogSlowSql() : this.stat.getLogSlowSql();
        if (logSlowSql != null && logSlowSql.booleanValue()) {
            properties.setProperty("druid.stat.logSlowSql", "true");
        }
        Long l6 = slowSqlMillis = this.stat.getSlowSqlMillis() == null ? g.stat.getSlowSqlMillis() : this.stat.getSlowSqlMillis();
        if (slowSqlMillis != null) {
            properties.setProperty("druid.stat.slowSqlMillis", slowSqlMillis.toString());
        }
        Boolean bl15 = mergeSql = this.stat.getMergeSql() == null ? g.stat.getMergeSql() : this.stat.getMergeSql();
        if (mergeSql != null && mergeSql.booleanValue()) {
            properties.setProperty("druid.stat.mergeSql", "true");
        }
        return properties;
    }

    public List<String> getProxyFilters() {
        return this.proxyFilters;
    }

    public void setProxyFilters(List<String> proxyFilters) {
        this.proxyFilters = proxyFilters;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Integer getMaxWait() {
        return this.maxWait;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Long getTimeBetweenLogStatsMillis() {
        return this.timeBetweenLogStatsMillis;
    }

    public Integer getStatSqlMaxSize() {
        return this.statSqlMaxSize;
    }

    public Long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public Long getMaxEvictableIdleTimeMillis() {
        return this.maxEvictableIdleTimeMillis;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public Boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public Boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Integer getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public Boolean getUseGlobalDataSourceStat() {
        return this.useGlobalDataSourceStat;
    }

    public Boolean getAsyncInit() {
        return this.asyncInit;
    }

    public String getFilters() {
        return this.filters;
    }

    public Boolean getClearFiltersEnable() {
        return this.clearFiltersEnable;
    }

    public Boolean getResetStatEnable() {
        return this.resetStatEnable;
    }

    public Integer getNotFullTimeoutRetryCount() {
        return this.notFullTimeoutRetryCount;
    }

    public Integer getMaxWaitThreadCount() {
        return this.maxWaitThreadCount;
    }

    public Boolean getFailFast() {
        return this.failFast;
    }

    public Long getPhyTimeoutMillis() {
        return this.phyTimeoutMillis;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Boolean getPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public Boolean getInitVariants() {
        return this.initVariants;
    }

    public Boolean getInitGlobalVariants() {
        return this.initGlobalVariants;
    }

    public Boolean getUseUnfairLock() {
        return this.useUnfairLock;
    }

    public Boolean getKillWhenSocketReadTimeout() {
        return this.killWhenSocketReadTimeout;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Integer getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public String getInitConnectionSqls() {
        return this.initConnectionSqls;
    }

    public Boolean getSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public Integer getConnectionErrorRetryAttempts() {
        return this.connectionErrorRetryAttempts;
    }

    public Boolean getBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public Boolean getRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public Integer getRemoveAbandonedTimeoutMillis() {
        return this.removeAbandonedTimeoutMillis;
    }

    public Boolean getLogAbandoned() {
        return this.logAbandoned;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public Integer getTransactionQueryTimeout() {
        return this.transactionQueryTimeout;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public DruidWallConfig getWall() {
        return this.wall;
    }

    public DruidStatConfig getStat() {
        return this.stat;
    }

    public DruidSlf4jConfig getSlf4j() {
        return this.slf4j;
    }

    public DruidConfig setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    public DruidConfig setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public DruidConfig setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public DruidConfig setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public DruidConfig setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public DruidConfig setTimeBetweenLogStatsMillis(Long timeBetweenLogStatsMillis) {
        this.timeBetweenLogStatsMillis = timeBetweenLogStatsMillis;
        return this;
    }

    public DruidConfig setStatSqlMaxSize(Integer statSqlMaxSize) {
        this.statSqlMaxSize = statSqlMaxSize;
        return this;
    }

    public DruidConfig setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        return this;
    }

    public DruidConfig setMaxEvictableIdleTimeMillis(Long maxEvictableIdleTimeMillis) {
        this.maxEvictableIdleTimeMillis = maxEvictableIdleTimeMillis;
        return this;
    }

    public DruidConfig setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
        return this;
    }

    public DruidConfig setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
        return this;
    }

    public DruidConfig setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
        return this;
    }

    public DruidConfig setDefaultTransactionIsolation(Integer defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        return this;
    }

    public DruidConfig setTestWhileIdle(Boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public DruidConfig setTestOnBorrow(Boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public DruidConfig setTestOnReturn(Boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public DruidConfig setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public DruidConfig setValidationQueryTimeout(Integer validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
        return this;
    }

    public DruidConfig setUseGlobalDataSourceStat(Boolean useGlobalDataSourceStat) {
        this.useGlobalDataSourceStat = useGlobalDataSourceStat;
        return this;
    }

    public DruidConfig setAsyncInit(Boolean asyncInit) {
        this.asyncInit = asyncInit;
        return this;
    }

    public DruidConfig setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public DruidConfig setClearFiltersEnable(Boolean clearFiltersEnable) {
        this.clearFiltersEnable = clearFiltersEnable;
        return this;
    }

    public DruidConfig setResetStatEnable(Boolean resetStatEnable) {
        this.resetStatEnable = resetStatEnable;
        return this;
    }

    public DruidConfig setNotFullTimeoutRetryCount(Integer notFullTimeoutRetryCount) {
        this.notFullTimeoutRetryCount = notFullTimeoutRetryCount;
        return this;
    }

    public DruidConfig setMaxWaitThreadCount(Integer maxWaitThreadCount) {
        this.maxWaitThreadCount = maxWaitThreadCount;
        return this;
    }

    public DruidConfig setFailFast(Boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public DruidConfig setPhyTimeoutMillis(Long phyTimeoutMillis) {
        this.phyTimeoutMillis = phyTimeoutMillis;
        return this;
    }

    public DruidConfig setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public DruidConfig setPoolPreparedStatements(Boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
        return this;
    }

    public DruidConfig setInitVariants(Boolean initVariants) {
        this.initVariants = initVariants;
        return this;
    }

    public DruidConfig setInitGlobalVariants(Boolean initGlobalVariants) {
        this.initGlobalVariants = initGlobalVariants;
        return this;
    }

    public DruidConfig setUseUnfairLock(Boolean useUnfairLock) {
        this.useUnfairLock = useUnfairLock;
        return this;
    }

    public DruidConfig setKillWhenSocketReadTimeout(Boolean killWhenSocketReadTimeout) {
        this.killWhenSocketReadTimeout = killWhenSocketReadTimeout;
        return this;
    }

    public DruidConfig setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public DruidConfig setMaxPoolPreparedStatementPerConnectionSize(Integer maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
        return this;
    }

    public DruidConfig setInitConnectionSqls(String initConnectionSqls) {
        this.initConnectionSqls = initConnectionSqls;
        return this;
    }

    public DruidConfig setSharePreparedStatements(Boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
        return this;
    }

    public DruidConfig setConnectionErrorRetryAttempts(Integer connectionErrorRetryAttempts) {
        this.connectionErrorRetryAttempts = connectionErrorRetryAttempts;
        return this;
    }

    public DruidConfig setBreakAfterAcquireFailure(Boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
        return this;
    }

    public DruidConfig setRemoveAbandoned(Boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
        return this;
    }

    public DruidConfig setRemoveAbandonedTimeoutMillis(Integer removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
        return this;
    }

    public DruidConfig setLogAbandoned(Boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
        return this;
    }

    public DruidConfig setQueryTimeout(Integer queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public DruidConfig setTransactionQueryTimeout(Integer transactionQueryTimeout) {
        this.transactionQueryTimeout = transactionQueryTimeout;
        return this;
    }

    public DruidConfig setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public DruidConfig setWall(DruidWallConfig wall) {
        this.wall = wall;
        return this;
    }

    public DruidConfig setStat(DruidStatConfig stat) {
        this.stat = stat;
        return this;
    }

    public DruidConfig setSlf4j(DruidSlf4jConfig slf4j) {
        this.slf4j = slf4j;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidConfig)) {
            return false;
        }
        DruidConfig other = (DruidConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$initialSize = this.getInitialSize();
        Integer other$initialSize = other.getInitialSize();
        if (this$initialSize == null ? other$initialSize != null : !((Object)this$initialSize).equals(other$initialSize)) {
            return false;
        }
        Integer this$maxActive = this.getMaxActive();
        Integer other$maxActive = other.getMaxActive();
        if (this$maxActive == null ? other$maxActive != null : !((Object)this$maxActive).equals(other$maxActive)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Integer this$maxWait = this.getMaxWait();
        Integer other$maxWait = other.getMaxWait();
        if (this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait)) {
            return false;
        }
        Long this$timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        Long other$timeBetweenEvictionRunsMillis = other.getTimeBetweenEvictionRunsMillis();
        if (this$timeBetweenEvictionRunsMillis == null ? other$timeBetweenEvictionRunsMillis != null : !((Object)this$timeBetweenEvictionRunsMillis).equals(other$timeBetweenEvictionRunsMillis)) {
            return false;
        }
        Long this$timeBetweenLogStatsMillis = this.getTimeBetweenLogStatsMillis();
        Long other$timeBetweenLogStatsMillis = other.getTimeBetweenLogStatsMillis();
        if (this$timeBetweenLogStatsMillis == null ? other$timeBetweenLogStatsMillis != null : !((Object)this$timeBetweenLogStatsMillis).equals(other$timeBetweenLogStatsMillis)) {
            return false;
        }
        Integer this$statSqlMaxSize = this.getStatSqlMaxSize();
        Integer other$statSqlMaxSize = other.getStatSqlMaxSize();
        if (this$statSqlMaxSize == null ? other$statSqlMaxSize != null : !((Object)this$statSqlMaxSize).equals(other$statSqlMaxSize)) {
            return false;
        }
        Long this$minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        Long other$minEvictableIdleTimeMillis = other.getMinEvictableIdleTimeMillis();
        if (this$minEvictableIdleTimeMillis == null ? other$minEvictableIdleTimeMillis != null : !((Object)this$minEvictableIdleTimeMillis).equals(other$minEvictableIdleTimeMillis)) {
            return false;
        }
        Long this$maxEvictableIdleTimeMillis = this.getMaxEvictableIdleTimeMillis();
        Long other$maxEvictableIdleTimeMillis = other.getMaxEvictableIdleTimeMillis();
        if (this$maxEvictableIdleTimeMillis == null ? other$maxEvictableIdleTimeMillis != null : !((Object)this$maxEvictableIdleTimeMillis).equals(other$maxEvictableIdleTimeMillis)) {
            return false;
        }
        Boolean this$defaultAutoCommit = this.getDefaultAutoCommit();
        Boolean other$defaultAutoCommit = other.getDefaultAutoCommit();
        if (this$defaultAutoCommit == null ? other$defaultAutoCommit != null : !((Object)this$defaultAutoCommit).equals(other$defaultAutoCommit)) {
            return false;
        }
        Boolean this$defaultReadOnly = this.getDefaultReadOnly();
        Boolean other$defaultReadOnly = other.getDefaultReadOnly();
        if (this$defaultReadOnly == null ? other$defaultReadOnly != null : !((Object)this$defaultReadOnly).equals(other$defaultReadOnly)) {
            return false;
        }
        Integer this$defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        Integer other$defaultTransactionIsolation = other.getDefaultTransactionIsolation();
        if (this$defaultTransactionIsolation == null ? other$defaultTransactionIsolation != null : !((Object)this$defaultTransactionIsolation).equals(other$defaultTransactionIsolation)) {
            return false;
        }
        Boolean this$testWhileIdle = this.getTestWhileIdle();
        Boolean other$testWhileIdle = other.getTestWhileIdle();
        if (this$testWhileIdle == null ? other$testWhileIdle != null : !((Object)this$testWhileIdle).equals(other$testWhileIdle)) {
            return false;
        }
        Boolean this$testOnBorrow = this.getTestOnBorrow();
        Boolean other$testOnBorrow = other.getTestOnBorrow();
        if (this$testOnBorrow == null ? other$testOnBorrow != null : !((Object)this$testOnBorrow).equals(other$testOnBorrow)) {
            return false;
        }
        Boolean this$testOnReturn = this.getTestOnReturn();
        Boolean other$testOnReturn = other.getTestOnReturn();
        if (this$testOnReturn == null ? other$testOnReturn != null : !((Object)this$testOnReturn).equals(other$testOnReturn)) {
            return false;
        }
        Integer this$validationQueryTimeout = this.getValidationQueryTimeout();
        Integer other$validationQueryTimeout = other.getValidationQueryTimeout();
        if (this$validationQueryTimeout == null ? other$validationQueryTimeout != null : !((Object)this$validationQueryTimeout).equals(other$validationQueryTimeout)) {
            return false;
        }
        Boolean this$useGlobalDataSourceStat = this.getUseGlobalDataSourceStat();
        Boolean other$useGlobalDataSourceStat = other.getUseGlobalDataSourceStat();
        if (this$useGlobalDataSourceStat == null ? other$useGlobalDataSourceStat != null : !((Object)this$useGlobalDataSourceStat).equals(other$useGlobalDataSourceStat)) {
            return false;
        }
        Boolean this$asyncInit = this.getAsyncInit();
        Boolean other$asyncInit = other.getAsyncInit();
        if (this$asyncInit == null ? other$asyncInit != null : !((Object)this$asyncInit).equals(other$asyncInit)) {
            return false;
        }
        Boolean this$clearFiltersEnable = this.getClearFiltersEnable();
        Boolean other$clearFiltersEnable = other.getClearFiltersEnable();
        if (this$clearFiltersEnable == null ? other$clearFiltersEnable != null : !((Object)this$clearFiltersEnable).equals(other$clearFiltersEnable)) {
            return false;
        }
        Boolean this$resetStatEnable = this.getResetStatEnable();
        Boolean other$resetStatEnable = other.getResetStatEnable();
        if (this$resetStatEnable == null ? other$resetStatEnable != null : !((Object)this$resetStatEnable).equals(other$resetStatEnable)) {
            return false;
        }
        Integer this$notFullTimeoutRetryCount = this.getNotFullTimeoutRetryCount();
        Integer other$notFullTimeoutRetryCount = other.getNotFullTimeoutRetryCount();
        if (this$notFullTimeoutRetryCount == null ? other$notFullTimeoutRetryCount != null : !((Object)this$notFullTimeoutRetryCount).equals(other$notFullTimeoutRetryCount)) {
            return false;
        }
        Integer this$maxWaitThreadCount = this.getMaxWaitThreadCount();
        Integer other$maxWaitThreadCount = other.getMaxWaitThreadCount();
        if (this$maxWaitThreadCount == null ? other$maxWaitThreadCount != null : !((Object)this$maxWaitThreadCount).equals(other$maxWaitThreadCount)) {
            return false;
        }
        Boolean this$failFast = this.getFailFast();
        Boolean other$failFast = other.getFailFast();
        if (this$failFast == null ? other$failFast != null : !((Object)this$failFast).equals(other$failFast)) {
            return false;
        }
        Long this$phyTimeoutMillis = this.getPhyTimeoutMillis();
        Long other$phyTimeoutMillis = other.getPhyTimeoutMillis();
        if (this$phyTimeoutMillis == null ? other$phyTimeoutMillis != null : !((Object)this$phyTimeoutMillis).equals(other$phyTimeoutMillis)) {
            return false;
        }
        Boolean this$keepAlive = this.getKeepAlive();
        Boolean other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        Boolean this$poolPreparedStatements = this.getPoolPreparedStatements();
        Boolean other$poolPreparedStatements = other.getPoolPreparedStatements();
        if (this$poolPreparedStatements == null ? other$poolPreparedStatements != null : !((Object)this$poolPreparedStatements).equals(other$poolPreparedStatements)) {
            return false;
        }
        Boolean this$initVariants = this.getInitVariants();
        Boolean other$initVariants = other.getInitVariants();
        if (this$initVariants == null ? other$initVariants != null : !((Object)this$initVariants).equals(other$initVariants)) {
            return false;
        }
        Boolean this$initGlobalVariants = this.getInitGlobalVariants();
        Boolean other$initGlobalVariants = other.getInitGlobalVariants();
        if (this$initGlobalVariants == null ? other$initGlobalVariants != null : !((Object)this$initGlobalVariants).equals(other$initGlobalVariants)) {
            return false;
        }
        Boolean this$useUnfairLock = this.getUseUnfairLock();
        Boolean other$useUnfairLock = other.getUseUnfairLock();
        if (this$useUnfairLock == null ? other$useUnfairLock != null : !((Object)this$useUnfairLock).equals(other$useUnfairLock)) {
            return false;
        }
        Boolean this$killWhenSocketReadTimeout = this.getKillWhenSocketReadTimeout();
        Boolean other$killWhenSocketReadTimeout = other.getKillWhenSocketReadTimeout();
        if (this$killWhenSocketReadTimeout == null ? other$killWhenSocketReadTimeout != null : !((Object)this$killWhenSocketReadTimeout).equals(other$killWhenSocketReadTimeout)) {
            return false;
        }
        Integer this$maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        Integer other$maxPoolPreparedStatementPerConnectionSize = other.getMaxPoolPreparedStatementPerConnectionSize();
        if (this$maxPoolPreparedStatementPerConnectionSize == null ? other$maxPoolPreparedStatementPerConnectionSize != null : !((Object)this$maxPoolPreparedStatementPerConnectionSize).equals(other$maxPoolPreparedStatementPerConnectionSize)) {
            return false;
        }
        Boolean this$sharePreparedStatements = this.getSharePreparedStatements();
        Boolean other$sharePreparedStatements = other.getSharePreparedStatements();
        if (this$sharePreparedStatements == null ? other$sharePreparedStatements != null : !((Object)this$sharePreparedStatements).equals(other$sharePreparedStatements)) {
            return false;
        }
        Integer this$connectionErrorRetryAttempts = this.getConnectionErrorRetryAttempts();
        Integer other$connectionErrorRetryAttempts = other.getConnectionErrorRetryAttempts();
        if (this$connectionErrorRetryAttempts == null ? other$connectionErrorRetryAttempts != null : !((Object)this$connectionErrorRetryAttempts).equals(other$connectionErrorRetryAttempts)) {
            return false;
        }
        Boolean this$breakAfterAcquireFailure = this.getBreakAfterAcquireFailure();
        Boolean other$breakAfterAcquireFailure = other.getBreakAfterAcquireFailure();
        if (this$breakAfterAcquireFailure == null ? other$breakAfterAcquireFailure != null : !((Object)this$breakAfterAcquireFailure).equals(other$breakAfterAcquireFailure)) {
            return false;
        }
        Boolean this$removeAbandoned = this.getRemoveAbandoned();
        Boolean other$removeAbandoned = other.getRemoveAbandoned();
        if (this$removeAbandoned == null ? other$removeAbandoned != null : !((Object)this$removeAbandoned).equals(other$removeAbandoned)) {
            return false;
        }
        Integer this$removeAbandonedTimeoutMillis = this.getRemoveAbandonedTimeoutMillis();
        Integer other$removeAbandonedTimeoutMillis = other.getRemoveAbandonedTimeoutMillis();
        if (this$removeAbandonedTimeoutMillis == null ? other$removeAbandonedTimeoutMillis != null : !((Object)this$removeAbandonedTimeoutMillis).equals(other$removeAbandonedTimeoutMillis)) {
            return false;
        }
        Boolean this$logAbandoned = this.getLogAbandoned();
        Boolean other$logAbandoned = other.getLogAbandoned();
        if (this$logAbandoned == null ? other$logAbandoned != null : !((Object)this$logAbandoned).equals(other$logAbandoned)) {
            return false;
        }
        Integer this$queryTimeout = this.getQueryTimeout();
        Integer other$queryTimeout = other.getQueryTimeout();
        if (this$queryTimeout == null ? other$queryTimeout != null : !((Object)this$queryTimeout).equals(other$queryTimeout)) {
            return false;
        }
        Integer this$transactionQueryTimeout = this.getTransactionQueryTimeout();
        Integer other$transactionQueryTimeout = other.getTransactionQueryTimeout();
        if (this$transactionQueryTimeout == null ? other$transactionQueryTimeout != null : !((Object)this$transactionQueryTimeout).equals(other$transactionQueryTimeout)) {
            return false;
        }
        String this$defaultCatalog = this.getDefaultCatalog();
        String other$defaultCatalog = other.getDefaultCatalog();
        if (this$defaultCatalog == null ? other$defaultCatalog != null : !this$defaultCatalog.equals(other$defaultCatalog)) {
            return false;
        }
        String this$validationQuery = this.getValidationQuery();
        String other$validationQuery = other.getValidationQuery();
        if (this$validationQuery == null ? other$validationQuery != null : !this$validationQuery.equals(other$validationQuery)) {
            return false;
        }
        String this$filters = this.getFilters();
        String other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        Properties this$connectionProperties = this.getConnectionProperties();
        Properties other$connectionProperties = other.getConnectionProperties();
        if (this$connectionProperties == null ? other$connectionProperties != null : !((Object)this$connectionProperties).equals(other$connectionProperties)) {
            return false;
        }
        String this$initConnectionSqls = this.getInitConnectionSqls();
        String other$initConnectionSqls = other.getInitConnectionSqls();
        if (this$initConnectionSqls == null ? other$initConnectionSqls != null : !this$initConnectionSqls.equals(other$initConnectionSqls)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        DruidWallConfig this$wall = this.getWall();
        DruidWallConfig other$wall = other.getWall();
        if (this$wall == null ? other$wall != null : !((Object)this$wall).equals(other$wall)) {
            return false;
        }
        DruidStatConfig this$stat = this.getStat();
        DruidStatConfig other$stat = other.getStat();
        if (this$stat == null ? other$stat != null : !((Object)this$stat).equals(other$stat)) {
            return false;
        }
        DruidSlf4jConfig this$slf4j = this.getSlf4j();
        DruidSlf4jConfig other$slf4j = other.getSlf4j();
        if (this$slf4j == null ? other$slf4j != null : !((Object)this$slf4j).equals(other$slf4j)) {
            return false;
        }
        List<String> this$proxyFilters = this.getProxyFilters();
        List<String> other$proxyFilters = other.getProxyFilters();
        return !(this$proxyFilters == null ? other$proxyFilters != null : !((Object)this$proxyFilters).equals(other$proxyFilters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $initialSize = this.getInitialSize();
        result = result * 59 + ($initialSize == null ? 43 : ((Object)$initialSize).hashCode());
        Integer $maxActive = this.getMaxActive();
        result = result * 59 + ($maxActive == null ? 43 : ((Object)$maxActive).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Integer $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        Long $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + ($timeBetweenEvictionRunsMillis == null ? 43 : ((Object)$timeBetweenEvictionRunsMillis).hashCode());
        Long $timeBetweenLogStatsMillis = this.getTimeBetweenLogStatsMillis();
        result = result * 59 + ($timeBetweenLogStatsMillis == null ? 43 : ((Object)$timeBetweenLogStatsMillis).hashCode());
        Integer $statSqlMaxSize = this.getStatSqlMaxSize();
        result = result * 59 + ($statSqlMaxSize == null ? 43 : ((Object)$statSqlMaxSize).hashCode());
        Long $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + ($minEvictableIdleTimeMillis == null ? 43 : ((Object)$minEvictableIdleTimeMillis).hashCode());
        Long $maxEvictableIdleTimeMillis = this.getMaxEvictableIdleTimeMillis();
        result = result * 59 + ($maxEvictableIdleTimeMillis == null ? 43 : ((Object)$maxEvictableIdleTimeMillis).hashCode());
        Boolean $defaultAutoCommit = this.getDefaultAutoCommit();
        result = result * 59 + ($defaultAutoCommit == null ? 43 : ((Object)$defaultAutoCommit).hashCode());
        Boolean $defaultReadOnly = this.getDefaultReadOnly();
        result = result * 59 + ($defaultReadOnly == null ? 43 : ((Object)$defaultReadOnly).hashCode());
        Integer $defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        result = result * 59 + ($defaultTransactionIsolation == null ? 43 : ((Object)$defaultTransactionIsolation).hashCode());
        Boolean $testWhileIdle = this.getTestWhileIdle();
        result = result * 59 + ($testWhileIdle == null ? 43 : ((Object)$testWhileIdle).hashCode());
        Boolean $testOnBorrow = this.getTestOnBorrow();
        result = result * 59 + ($testOnBorrow == null ? 43 : ((Object)$testOnBorrow).hashCode());
        Boolean $testOnReturn = this.getTestOnReturn();
        result = result * 59 + ($testOnReturn == null ? 43 : ((Object)$testOnReturn).hashCode());
        Integer $validationQueryTimeout = this.getValidationQueryTimeout();
        result = result * 59 + ($validationQueryTimeout == null ? 43 : ((Object)$validationQueryTimeout).hashCode());
        Boolean $useGlobalDataSourceStat = this.getUseGlobalDataSourceStat();
        result = result * 59 + ($useGlobalDataSourceStat == null ? 43 : ((Object)$useGlobalDataSourceStat).hashCode());
        Boolean $asyncInit = this.getAsyncInit();
        result = result * 59 + ($asyncInit == null ? 43 : ((Object)$asyncInit).hashCode());
        Boolean $clearFiltersEnable = this.getClearFiltersEnable();
        result = result * 59 + ($clearFiltersEnable == null ? 43 : ((Object)$clearFiltersEnable).hashCode());
        Boolean $resetStatEnable = this.getResetStatEnable();
        result = result * 59 + ($resetStatEnable == null ? 43 : ((Object)$resetStatEnable).hashCode());
        Integer $notFullTimeoutRetryCount = this.getNotFullTimeoutRetryCount();
        result = result * 59 + ($notFullTimeoutRetryCount == null ? 43 : ((Object)$notFullTimeoutRetryCount).hashCode());
        Integer $maxWaitThreadCount = this.getMaxWaitThreadCount();
        result = result * 59 + ($maxWaitThreadCount == null ? 43 : ((Object)$maxWaitThreadCount).hashCode());
        Boolean $failFast = this.getFailFast();
        result = result * 59 + ($failFast == null ? 43 : ((Object)$failFast).hashCode());
        Long $phyTimeoutMillis = this.getPhyTimeoutMillis();
        result = result * 59 + ($phyTimeoutMillis == null ? 43 : ((Object)$phyTimeoutMillis).hashCode());
        Boolean $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        Boolean $poolPreparedStatements = this.getPoolPreparedStatements();
        result = result * 59 + ($poolPreparedStatements == null ? 43 : ((Object)$poolPreparedStatements).hashCode());
        Boolean $initVariants = this.getInitVariants();
        result = result * 59 + ($initVariants == null ? 43 : ((Object)$initVariants).hashCode());
        Boolean $initGlobalVariants = this.getInitGlobalVariants();
        result = result * 59 + ($initGlobalVariants == null ? 43 : ((Object)$initGlobalVariants).hashCode());
        Boolean $useUnfairLock = this.getUseUnfairLock();
        result = result * 59 + ($useUnfairLock == null ? 43 : ((Object)$useUnfairLock).hashCode());
        Boolean $killWhenSocketReadTimeout = this.getKillWhenSocketReadTimeout();
        result = result * 59 + ($killWhenSocketReadTimeout == null ? 43 : ((Object)$killWhenSocketReadTimeout).hashCode());
        Integer $maxPoolPreparedStatementPerConnectionSize = this.getMaxPoolPreparedStatementPerConnectionSize();
        result = result * 59 + ($maxPoolPreparedStatementPerConnectionSize == null ? 43 : ((Object)$maxPoolPreparedStatementPerConnectionSize).hashCode());
        Boolean $sharePreparedStatements = this.getSharePreparedStatements();
        result = result * 59 + ($sharePreparedStatements == null ? 43 : ((Object)$sharePreparedStatements).hashCode());
        Integer $connectionErrorRetryAttempts = this.getConnectionErrorRetryAttempts();
        result = result * 59 + ($connectionErrorRetryAttempts == null ? 43 : ((Object)$connectionErrorRetryAttempts).hashCode());
        Boolean $breakAfterAcquireFailure = this.getBreakAfterAcquireFailure();
        result = result * 59 + ($breakAfterAcquireFailure == null ? 43 : ((Object)$breakAfterAcquireFailure).hashCode());
        Boolean $removeAbandoned = this.getRemoveAbandoned();
        result = result * 59 + ($removeAbandoned == null ? 43 : ((Object)$removeAbandoned).hashCode());
        Integer $removeAbandonedTimeoutMillis = this.getRemoveAbandonedTimeoutMillis();
        result = result * 59 + ($removeAbandonedTimeoutMillis == null ? 43 : ((Object)$removeAbandonedTimeoutMillis).hashCode());
        Boolean $logAbandoned = this.getLogAbandoned();
        result = result * 59 + ($logAbandoned == null ? 43 : ((Object)$logAbandoned).hashCode());
        Integer $queryTimeout = this.getQueryTimeout();
        result = result * 59 + ($queryTimeout == null ? 43 : ((Object)$queryTimeout).hashCode());
        Integer $transactionQueryTimeout = this.getTransactionQueryTimeout();
        result = result * 59 + ($transactionQueryTimeout == null ? 43 : ((Object)$transactionQueryTimeout).hashCode());
        String $defaultCatalog = this.getDefaultCatalog();
        result = result * 59 + ($defaultCatalog == null ? 43 : $defaultCatalog.hashCode());
        String $validationQuery = this.getValidationQuery();
        result = result * 59 + ($validationQuery == null ? 43 : $validationQuery.hashCode());
        String $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        Properties $connectionProperties = this.getConnectionProperties();
        result = result * 59 + ($connectionProperties == null ? 43 : ((Object)$connectionProperties).hashCode());
        String $initConnectionSqls = this.getInitConnectionSqls();
        result = result * 59 + ($initConnectionSqls == null ? 43 : $initConnectionSqls.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        DruidWallConfig $wall = this.getWall();
        result = result * 59 + ($wall == null ? 43 : ((Object)$wall).hashCode());
        DruidStatConfig $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : ((Object)$stat).hashCode());
        DruidSlf4jConfig $slf4j = this.getSlf4j();
        result = result * 59 + ($slf4j == null ? 43 : ((Object)$slf4j).hashCode());
        List<String> $proxyFilters = this.getProxyFilters();
        result = result * 59 + ($proxyFilters == null ? 43 : ((Object)$proxyFilters).hashCode());
        return result;
    }

    public String toString() {
        return "DruidConfig(initialSize=" + this.getInitialSize() + ", maxActive=" + this.getMaxActive() + ", minIdle=" + this.getMinIdle() + ", maxWait=" + this.getMaxWait() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", timeBetweenLogStatsMillis=" + this.getTimeBetweenLogStatsMillis() + ", statSqlMaxSize=" + this.getStatSqlMaxSize() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", maxEvictableIdleTimeMillis=" + this.getMaxEvictableIdleTimeMillis() + ", defaultCatalog=" + this.getDefaultCatalog() + ", defaultAutoCommit=" + this.getDefaultAutoCommit() + ", defaultReadOnly=" + this.getDefaultReadOnly() + ", defaultTransactionIsolation=" + this.getDefaultTransactionIsolation() + ", testWhileIdle=" + this.getTestWhileIdle() + ", testOnBorrow=" + this.getTestOnBorrow() + ", testOnReturn=" + this.getTestOnReturn() + ", validationQuery=" + this.getValidationQuery() + ", validationQueryTimeout=" + this.getValidationQueryTimeout() + ", useGlobalDataSourceStat=" + this.getUseGlobalDataSourceStat() + ", asyncInit=" + this.getAsyncInit() + ", filters=" + this.getFilters() + ", clearFiltersEnable=" + this.getClearFiltersEnable() + ", resetStatEnable=" + this.getResetStatEnable() + ", notFullTimeoutRetryCount=" + this.getNotFullTimeoutRetryCount() + ", maxWaitThreadCount=" + this.getMaxWaitThreadCount() + ", failFast=" + this.getFailFast() + ", phyTimeoutMillis=" + this.getPhyTimeoutMillis() + ", keepAlive=" + this.getKeepAlive() + ", poolPreparedStatements=" + this.getPoolPreparedStatements() + ", initVariants=" + this.getInitVariants() + ", initGlobalVariants=" + this.getInitGlobalVariants() + ", useUnfairLock=" + this.getUseUnfairLock() + ", killWhenSocketReadTimeout=" + this.getKillWhenSocketReadTimeout() + ", connectionProperties=" + this.getConnectionProperties() + ", maxPoolPreparedStatementPerConnectionSize=" + this.getMaxPoolPreparedStatementPerConnectionSize() + ", initConnectionSqls=" + this.getInitConnectionSqls() + ", sharePreparedStatements=" + this.getSharePreparedStatements() + ", connectionErrorRetryAttempts=" + this.getConnectionErrorRetryAttempts() + ", breakAfterAcquireFailure=" + this.getBreakAfterAcquireFailure() + ", removeAbandoned=" + this.getRemoveAbandoned() + ", removeAbandonedTimeoutMillis=" + this.getRemoveAbandonedTimeoutMillis() + ", logAbandoned=" + this.getLogAbandoned() + ", queryTimeout=" + this.getQueryTimeout() + ", transactionQueryTimeout=" + this.getTransactionQueryTimeout() + ", publicKey=" + this.getPublicKey() + ", wall=" + this.getWall() + ", stat=" + this.getStat() + ", slf4j=" + this.getSlf4j() + ", proxyFilters=" + this.getProxyFilters() + ")";
    }
}

