/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import com.baomidou.dynamic.datasource.ds.AbstractRoutingDataSource;
import com.baomidou.dynamic.datasource.ds.GroupDataSource;
import com.baomidou.dynamic.datasource.exception.CannotFindDataSourceException;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.strategy.LoadBalanceDynamicDataSourceStrategy;
import com.baomidou.dynamic.datasource.toolkit.DatabasebUtils;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class DynamicRoutingDataSource
extends AbstractRoutingDataSource
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicRoutingDataSource.class);
    private static final String UNDERLINE = "_";
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private final Map<String, GroupDataSource> groupDataSources = new ConcurrentHashMap<String, GroupDataSource>();
    @Autowired
    private List<DynamicDataSourceProvider> providers;
    private Class<? extends DynamicDataSourceStrategy> strategy = LoadBalanceDynamicDataSourceStrategy.class;
    private String primary = "master";
    private Boolean strict = false;
    private Boolean p6spy = false;
    private Boolean seata = false;

    @Override
    public DataSource determineDataSource() {
        String dsKey = DynamicDataSourceContextHolder.peek();
        return this.getDataSource(dsKey);
    }

    private DataSource determinePrimaryDataSource() {
        log.debug("dynamic-datasource switch to the primary datasource");
        DataSource dataSource = this.dataSourceMap.get(this.primary);
        if (dataSource != null) {
            return dataSource;
        }
        GroupDataSource groupDataSource = this.groupDataSources.get(this.primary);
        if (groupDataSource != null) {
            return groupDataSource.determineDataSource();
        }
        throw new CannotFindDataSourceException("dynamic-datasource can not find primary datasource");
    }

    public Map<String, DataSource> getCurrentDataSources() {
        return this.dataSourceMap;
    }

    public Map<String, GroupDataSource> getCurrentGroupDataSources() {
        return this.groupDataSources;
    }

    public DataSource getDataSource(String ds) {
        if (StringUtils.isEmpty((Object)ds)) {
            return this.determinePrimaryDataSource();
        }
        if (!this.groupDataSources.isEmpty() && this.groupDataSources.containsKey(ds)) {
            log.debug("dynamic-datasource switch to the datasource named [{}]", (Object)ds);
            return this.groupDataSources.get(ds).determineDataSource();
        }
        if (this.dataSourceMap.containsKey(ds)) {
            log.debug("dynamic-datasource switch to the datasource named [{}]", (Object)ds);
            return this.dataSourceMap.get(ds);
        }
        if (this.strict.booleanValue()) {
            throw new CannotFindDataSourceException("dynamic-datasource could not find a datasource named" + ds);
        }
        return this.determinePrimaryDataSource();
    }

    public synchronized void addDataSource(String ds, DataSource dataSource) {
        DataSource oldDataSource = this.dataSourceMap.put(ds, dataSource);
        this.addGroupDataSource(ds, dataSource);
        if (oldDataSource != null) {
            try {
                this.closeDataSource(oldDataSource);
            }
            catch (Exception e) {
                log.error("dynamic-datasource - remove the database named [{}]  failed", (Object)ds, (Object)e);
            }
        }
        log.info("dynamic-datasource - add a datasource named [{}] success", (Object)ds);
    }

    private void addGroupDataSource(String ds, DataSource dataSource) {
        if (ds.contains(UNDERLINE)) {
            String group = ds.split(UNDERLINE)[0];
            GroupDataSource groupDataSource = this.groupDataSources.get(group);
            if (groupDataSource == null) {
                try {
                    groupDataSource = new GroupDataSource(group, this.strategy.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    this.groupDataSources.put(group, groupDataSource);
                }
                catch (Exception e) {
                    throw new RuntimeException("dynamic-datasource - add the datasource named " + ds + " error", e);
                }
            }
            groupDataSource.addDatasource(ds, dataSource);
        }
    }

    public synchronized void removeDataSource(String ds) {
        if (!StringUtils.hasText((String)ds)) {
            throw new RuntimeException("remove parameter could not be empty");
        }
        if (this.primary.equals(ds)) {
            throw new RuntimeException("could not remove primary datasource");
        }
        if (this.dataSourceMap.containsKey(ds)) {
            DataSource oldDataSource;
            String group;
            DataSource dataSource = this.dataSourceMap.remove(ds);
            try {
                this.closeDataSource(dataSource);
            }
            catch (Exception e) {
                log.error("dynamic-datasource - remove the database named [{}]  failed", (Object)ds, (Object)e);
            }
            if (ds.contains(UNDERLINE) && this.groupDataSources.containsKey(group = ds.split(UNDERLINE)[0]) && (oldDataSource = this.groupDataSources.get(group).removeDatasource(ds)) == null && log.isWarnEnabled()) {
                log.warn("fail for remove datasource from group. dataSource: {} ,group: {}", (Object)ds, (Object)group);
            }
            log.info("dynamic-datasource - remove the database named [{}] success", (Object)ds);
        } else {
            log.warn("dynamic-datasource - could not find a database named [{}]", (Object)ds);
        }
    }

    private void closeDataSource(DataSource dataSource) throws Exception {
        DatabasebUtils.closeDataSource(dataSource);
    }

    public void destroy() throws Exception {
        log.info("dynamic-datasource start closing ....");
        for (Map.Entry<String, DataSource> item : this.dataSourceMap.entrySet()) {
            this.closeDataSource(item.getValue());
        }
        log.info("dynamic-datasource all closed success,bye");
    }

    public void afterPropertiesSet() throws Exception {
        this.checkEnv();
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>();
        for (DynamicDataSourceProvider dynamicDataSourceProvider : this.providers) {
            dataSources.putAll(dynamicDataSourceProvider.loadDataSources());
        }
        for (Map.Entry entry : dataSources.entrySet()) {
            this.addDataSource((String)entry.getKey(), (DataSource)entry.getValue());
        }
        if (this.groupDataSources.containsKey(this.primary)) {
            log.info("dynamic-datasource initial loaded [{}] datasource,primary group datasource named [{}]", (Object)dataSources.size(), (Object)this.primary);
        } else if (this.dataSourceMap.containsKey(this.primary)) {
            log.info("dynamic-datasource initial loaded [{}] datasource,primary datasource named [{}]", (Object)dataSources.size(), (Object)this.primary);
        } else {
            log.warn("dynamic-datasource initial loaded [{}] datasource,Please add your primary datasource or check your configuration", (Object)dataSources.size());
        }
    }

    private void checkEnv() {
        if (this.p6spy.booleanValue()) {
            try {
                Class.forName("com.p6spy.engine.spy.P6DataSource");
                log.info("dynamic-datasource detect P6SPY plugin and enabled it");
            }
            catch (Exception e) {
                throw new RuntimeException("dynamic-datasource enabled P6SPY ,however without p6spy dependency", e);
            }
        }
        if (this.seata.booleanValue()) {
            try {
                Class.forName("io.seata.rm.datasource.DataSourceProxy");
                log.info("dynamic-datasource detect ALIBABA SEATA and enabled it");
            }
            catch (Exception e) {
                throw new RuntimeException("dynamic-datasource enabled ALIBABA SEATA,however without seata dependency", e);
            }
        }
    }

    public void setStrategy(Class<? extends DynamicDataSourceStrategy> strategy) {
        this.strategy = strategy;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public void setStrict(Boolean strict) {
        this.strict = strict;
    }

    public void setP6spy(Boolean p6spy) {
        this.p6spy = p6spy;
    }

    public void setSeata(Boolean seata) {
        this.seata = seata;
    }
}

