/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDataSourceClassResolver {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceClassResolver.class);
    private boolean mpEnabled = false;
    private Field mapperInterfaceField;

    public DynamicDataSourceClassResolver() {
        Class<?> proxyClass = null;
        try {
            proxyClass = Class.forName("com.baomidou.mybatisplus.core.override.MybatisMapperProxy");
        }
        catch (ClassNotFoundException e1) {
            try {
                proxyClass = Class.forName("com.baomidou.mybatisplus.core.override.PageMapperProxy");
            }
            catch (ClassNotFoundException e2) {
                try {
                    proxyClass = Class.forName("org.apache.ibatis.binding.MapperProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (proxyClass != null) {
            try {
                this.mapperInterfaceField = proxyClass.getDeclaredField("mapperInterface");
                this.mapperInterfaceField.setAccessible(true);
                this.mpEnabled = true;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public Class<?> targetClass(MethodInvocation invocation) throws IllegalAccessException {
        if (this.mpEnabled) {
            Object target = invocation.getThis();
            Class targetClass = target.getClass();
            return Proxy.isProxyClass(targetClass) ? (Class)this.mapperInterfaceField.get(Proxy.getInvocationHandler(target)) : targetClass;
        }
        return invocation.getMethod().getDeclaringClass();
    }
}

