/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.console.dataset;

import com.baidubce.appbuilder.base.component.Component;
import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import com.baidubce.appbuilder.model.dataset.DatasetCreateResponse;
import com.baidubce.appbuilder.model.dataset.DocumentAddResponse;
import com.baidubce.appbuilder.model.dataset.DocumentDeleteResponse;
import com.baidubce.appbuilder.model.dataset.DocumentListResponse;
import com.baidubce.appbuilder.model.dataset.FileUploadResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class Dataset
extends Component {
    String datasetId;

    public Dataset() {
    }

    public Dataset(String secretKey) {
        super(secretKey);
    }

    public Dataset(String secretKey, String datasetId) {
        super(secretKey);
        this.datasetId = datasetId;
    }

    public String createDataset(String datasetName) throws IOException, AppBuilderServerException {
        String url = "/api/v1/ai_engine/agi_platform/v1/datasets/create";
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("name", datasetName);
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequest(url, new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)DatasetCreateResponse.class));
        DatasetCreateResponse respBody = (DatasetCreateResponse)response.getBody();
        if (respBody.getCode() != 0) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.getCode(), respBody.getMessage());
        }
        this.datasetId = respBody.getResult().getId();
        return this.datasetId;
    }

    private String uploadDocument(String filePath) throws IOException, AppBuilderServerException {
        String url = "/api/v1/ai_engine/agi_platform/v1/datasets/files/upload";
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY).setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody("file", new File(filePath));
        ClassicHttpRequest postRequest = this.httpClient.createPostRequest(url, builder.build());
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)FileUploadResponse.class));
        FileUploadResponse respBody = (FileUploadResponse)response.getBody();
        if (respBody.getCode() != 0) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.getCode(), respBody.getMessage());
        }
        return respBody.getResult().getId();
    }

    public String[] addDocuments(List<String> filePaths, boolean isCustomProcessRule, Map<String, Object> customProcessRule, boolean isEnhanced) throws IOException, AppBuilderServerException {
        String url = "/api/v1/ai_engine/agi_platform/v1/datasets/documents";
        if (this.datasetId == null || this.datasetId.isEmpty()) {
            throw new RuntimeException("Param 'datasetId' is required! Please set param or call createDataset() first");
        }
        ArrayList<String> fileIds = new ArrayList<String>(filePaths.size());
        for (String filePath : filePaths) {
            String fileId = this.uploadDocument(filePath);
            fileIds.add(fileId);
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("dataset_id", this.datasetId);
        requestBody.put("file_ids", fileIds);
        requestBody.put("is_custom_process_rule", isCustomProcessRule);
        requestBody.put("is_enhanced", isEnhanced);
        if (isCustomProcessRule && customProcessRule != null) {
            requestBody.put("custom_process_rule", customProcessRule);
        }
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequest(url, new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)DocumentAddResponse.class));
        DocumentAddResponse respBody = (DocumentAddResponse)response.getBody();
        if (respBody.getCode() != 0) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.getCode(), respBody.getMessage());
        }
        return respBody.getResult().getDocumentIds();
    }

    public DocumentListResponse getDocumentList(int page, int limit, String keywork) throws IOException, AppBuilderServerException {
        String url = "/api/v1/ai_engine/agi_platform/v1/datasets/documents/list_page";
        if (this.datasetId == null || this.datasetId.isEmpty()) {
            throw new RuntimeException("Param 'datasetId' is required! Please set param or call createDataset() first");
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("dataset_id", this.datasetId);
        requestBody.put("page", page);
        requestBody.put("limit", limit);
        requestBody.put("keyword", keywork);
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequest(url, new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)DocumentListResponse.class));
        DocumentListResponse respBody = (DocumentListResponse)response.getBody();
        if (respBody.getCode() != 0) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.getCode(), respBody.getMessage());
        }
        return respBody;
    }

    public void deleteDocument(String documentId) throws IOException, AppBuilderServerException {
        String url = "/api/v1/ai_engine/agi_platform/v1/datasets/document/delete";
        if (this.datasetId == null || this.datasetId.isEmpty()) {
            throw new RuntimeException("Param 'datasetId' is required! Please set param or call createDataset() first");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("dataset_id", this.datasetId);
        requestBody.put("document_id", documentId);
        String jsonBody = JsonUtils.serialize(requestBody);
        ClassicHttpRequest postRequest = this.httpClient.createPostRequest(url, new StringEntity(jsonBody, StandardCharsets.UTF_8));
        postRequest.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute(postRequest, (Type)((Object)DocumentDeleteResponse.class));
        DocumentDeleteResponse respBody = (DocumentDeleteResponse)response.getBody();
        if (respBody.getCode() != 0) {
            throw new AppBuilderServerException(response.getRequestId(), response.getCode(), response.getMessage(), respBody.getCode(), respBody.getMessage());
        }
    }

    public void deleteDocuments(String[] documentIds) throws IOException, AppBuilderServerException {
        for (String documentId : documentIds) {
            this.deleteDocument(documentId);
        }
    }
}

