/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.base.utils.http;

import com.baidubce.appbuilder.base.exception.AppBuilderServerException;
import com.baidubce.appbuilder.base.utils.http.HttpResponse;
import com.baidubce.appbuilder.base.utils.iterator.StreamIterator;
import com.baidubce.appbuilder.base.utils.json.JsonUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpClient {
    public String SecretKey;
    public String Gateway;
    private final CloseableHttpClient client;

    public HttpClient(String secretKey, String gateway) {
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(300L, TimeUnit.SECONDS).build();
        this.client = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        this.SecretKey = secretKey;
        this.Gateway = gateway;
    }

    public ClassicHttpRequest createPostRequest(String url, HttpEntity entity) {
        String requestURL = this.Gateway + url;
        HttpPost httpPost = new HttpPost(requestURL);
        httpPost.setHeader("X-Appbuilder-Authorization", this.SecretKey);
        httpPost.setEntity(entity);
        return httpPost;
    }

    public <T> HttpResponse<T> execute(ClassicHttpRequest request, Type bodyType) throws IOException, AppBuilderServerException {
        HttpResponse httpResponse = this.client.execute(request, (ClassicHttpResponse resp) -> {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            for (Header header : resp.getHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            String requestId = (String)headers.get("X-Appbuilder-Request-Id");
            String stringBody = EntityUtils.toString(resp.getEntity());
            HttpResponse response = new HttpResponse().setCode(resp.getCode()).setMessage(resp.getReasonPhrase()).setRequestId(requestId).setHeaders(headers).setStringBody(stringBody);
            if (resp.getCode() == 200) {
                response.setBody(JsonUtils.deserialize(stringBody, bodyType));
            }
            return response;
        });
        if (httpResponse.getCode() != 200) {
            throw new AppBuilderServerException(httpResponse.getRequestId(), httpResponse.getCode(), httpResponse.getMessage(), httpResponse.getStringBody());
        }
        return httpResponse;
    }

    public <T> HttpResponse<Iterator<T>> executeSSE(ClassicHttpRequest request, Type bodyType) throws IOException, AppBuilderServerException {
        CloseableHttpResponse resp = this.client.execute(request);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Header header : resp.getHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        String requestId = (String)headers.get("X-Appbuilder-Request-Id");
        if (resp.getCode() != 200) {
            String stringBody = "";
            try {
                stringBody = EntityUtils.toString(resp.getEntity());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            throw new AppBuilderServerException(requestId, resp.getCode(), resp.getReasonPhrase(), stringBody);
        }
        return new HttpResponse().setCode(resp.getCode()).setMessage(resp.getReasonPhrase()).setRequestId(requestId).setHeaders(headers).setBody(new StreamIterator(resp, bodyType));
    }
}

