/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.appbuilder.base.component;

import com.baidubce.appbuilder.base.utils.http.HttpClient;

public class Component {
    protected HttpClient httpClient;

    public Component() {
        this.initClient("", "");
    }

    public Component(String secretKey) {
        this.initClient(secretKey, "");
    }

    public Component(String secretKey, String gateway) {
        this.initClient(secretKey, gateway);
    }

    private void initClient(String secretKey, String gateway) {
        if ((secretKey == null || secretKey.isEmpty()) && (secretKey = System.getProperty("APPBUILDER_TOKEN")) == null && (secretKey = System.getenv("APPBUILDER_TOKEN")) == null) {
            throw new RuntimeException("param secretKey is null and env APPBUILDER_TOKEN not set!");
        }
        if ((gateway == null || gateway.isEmpty()) && (gateway = System.getProperty("GATEWAY_URL")) == null && (gateway = System.getenv("GATEWAY_URL")) == null) {
            gateway = "https://appbuilder.baidu.com";
        }
        if (!secretKey.startsWith("Bearer")) {
            secretKey = String.format("Bearer %s", secretKey);
        }
        this.httpClient = new HttpClient(secretKey, gateway);
    }
}

