/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.imagesearch;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONObject;

public class AipImageSearch
extends BaseClient {
    public AipImageSearch(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject sameHqAdd(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqAdd(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.sameHqAdd(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sameHqAddUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqSearch(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqSearch(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.sameHqSearch(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sameHqSearchUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqUpdate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqUpdate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.sameHqUpdate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sameHqUpdateUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqDeleteByImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqDeleteByImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.sameHqDeleteByImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject sameHqDeleteByUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sameHqDeleteBySign(String contSign, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("cont_sign", contSign);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/realtime_search/same_hq/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarAdd(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarAdd(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.similarAdd(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject similarAddUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarSearch(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarSearch(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.similarSearch(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject similarSearchUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarUpdate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarUpdate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.similarUpdate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject similarUpdateUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarDeleteByImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarDeleteByImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.similarDeleteByImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject similarDeleteByUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject similarDeleteBySign(String contSign, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("cont_sign", contSign);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/similar/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productAdd(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productAdd(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.productAdd(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject productAddUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/add");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productSearch(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productSearch(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.productSearch(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject productSearchUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/search");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productUpdate(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productUpdate(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.productUpdate(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject productUpdateUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/update");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productDeleteByImage(byte[] image, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(image);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productDeleteByImage(String image, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(image);
            return this.productDeleteByImage(data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject productDeleteByUrl(String url, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", url);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject productDeleteBySign(String contSign, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("cont_sign", contSign);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/image-classify/v1/realtime_search/product/delete");
        this.postOperation(request);
        return this.requestServer(request);
    }
}

