/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ImplUtils {
    private static final String RETRY_AFTER_HEADER = "Retry-After";
    private static final String RETRY_AFTER_MS_HEADER = "retry-after-ms";
    private static final String X_MS_RETRY_AFTER_MS_HEADER = "x-ms-retry-after-ms";

    public static Duration getRetryAfterFromHeaders(HttpHeaders headers, Supplier<OffsetDateTime> nowSupplier) {
        Duration retryDelay = ImplUtils.tryGetRetryDelay(headers, X_MS_RETRY_AFTER_MS_HEADER, ImplUtils::tryGetDelayMillis);
        if (retryDelay != null) {
            return retryDelay;
        }
        retryDelay = ImplUtils.tryGetRetryDelay(headers, RETRY_AFTER_MS_HEADER, ImplUtils::tryGetDelayMillis);
        if (retryDelay != null) {
            return retryDelay;
        }
        retryDelay = ImplUtils.tryGetRetryDelay(headers, RETRY_AFTER_HEADER, headerValue -> ImplUtils.tryParseLongOrDateTime(headerValue, nowSupplier));
        if (retryDelay != null) {
            return retryDelay;
        }
        return null;
    }

    private static Duration tryGetRetryDelay(HttpHeaders headers, String headerName, Function<String, Duration> delayParser) {
        String headerValue = headers.getValue(headerName);
        return CoreUtils.isNullOrEmpty(headerValue) ? null : delayParser.apply(headerValue);
    }

    private static Duration tryGetDelayMillis(String value) {
        long delayMillis = ImplUtils.tryParseLong(value);
        return delayMillis >= 0L ? Duration.ofMillis(delayMillis) : null;
    }

    private static Duration tryParseLongOrDateTime(String value, Supplier<OffsetDateTime> nowSupplier) {
        long delaySeconds;
        try {
            OffsetDateTime retryAfter = new DateTimeRfc1123(value).getDateTime();
            delaySeconds = nowSupplier.get().until(retryAfter, ChronoUnit.SECONDS);
        }
        catch (DateTimeException ex) {
            delaySeconds = ImplUtils.tryParseLong(value);
        }
        return delaySeconds >= 0L ? Duration.ofSeconds(delaySeconds) : null;
    }

    private static long tryParseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public static void writeByteBufferToStream(ByteBuffer buffer, OutputStream stream) throws IOException {
        if (buffer.hasArray()) {
            stream.write(buffer.array(), buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + buffer.remaining());
            return;
        }
        if (stream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)stream;
            fileOutputStream.getChannel().write(buffer);
            return;
        }
        stream.write(FluxUtil.byteBufferToArray(buffer));
    }

    private ImplUtils() {
    }
}

