/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExceptionTestContextImpl;
import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.SessionStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.SystemAttributeContext;
import com.aventstack.extentreports.TestAttributeTestContextProvider;
import com.aventstack.extentreports.configuration.Config;
import com.aventstack.extentreports.configuration.ConfigLoader;
import com.aventstack.extentreports.configuration.ConfigMap;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Test;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractReporter
implements ExtentReporter {
    private static final Logger logger = Logger.getLogger(AbstractReporter.class.getName());
    private AnalysisStrategy strategy;
    protected Date startTime;
    protected Date endTime;
    protected List<Status> levels;
    protected List<Test> testList;
    protected List<String> testRunnerLogs;
    protected Map<String, Object> configMap;
    protected Map<String, Object> templateMap;
    protected String filePath;
    protected ConfigMap configContext;
    protected ExceptionTestContextImpl exceptionContext;
    protected TestAttributeTestContextProvider<Category> categoryContext;
    protected TestAttributeTestContextProvider<Author> authorContext;
    protected SystemAttributeContext systemAttributeContext;
    protected SessionStatusStats sc;

    public AbstractReporter() {
        this.setStartTime(Calendar.getInstance().getTime());
    }

    public void loadXMLConfig(String filePath) {
        this.loadXMLConfig(new File(filePath));
    }

    public void loadXMLConfig(File file) {
        ConfigMap config = new ConfigLoader(file).getConfigurationHash();
        config.getConfigList().forEach(this.configContext::setConfig);
    }

    public void loadConfig(Properties properties) {
        properties.entrySet().forEach(o -> {
            Config c = new Config();
            c.setKey(o.getKey().toString());
            c.setValue(o.getValue());
            this.configContext.setConfig(c);
        });
    }

    public void loadConfig(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
            this.loadConfig(properties);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Default Properties file not found", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to load properties file", e);
        }
    }

    public void loadConfig(String filePath) {
        try {
            FileInputStream is = new FileInputStream(filePath);
            this.loadConfig(is);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Default Properties file not found", e);
        }
    }

    @Override
    public void setStatusCount(SessionStatusStats sc) {
        this.sc = sc;
    }

    public SessionStatusStats getStatusCount() {
        if (this.sc != null) {
            this.sc.refresh(this.testList);
            return this.sc;
        }
        this.sc = new SessionStatusStats(this.strategy);
        this.sc.refresh(this.testList);
        return this.sc;
    }

    @Override
    public void setSystemAttributeContext(SystemAttributeContext systemAttributeContext) {
        this.systemAttributeContext = systemAttributeContext;
    }

    public SystemAttributeContext getSystemAttributeContext() {
        return this.systemAttributeContext;
    }

    @Override
    public void setCategoryContextInfo(TestAttributeTestContextProvider<Category> categoryContext) {
        this.categoryContext = categoryContext;
    }

    public TestAttributeTestContextProvider<Category> getCategoryContextInfo() {
        return this.categoryContext;
    }

    @Override
    public void setAuthorContextInfo(TestAttributeTestContextProvider<Author> authorContext) {
        this.authorContext = authorContext;
    }

    public TestAttributeTestContextProvider<Author> getAuthorContextInfo() {
        return this.authorContext;
    }

    @Override
    public void setTestRunnerLogs(List<String> testRunnerLogs) {
        this.testRunnerLogs = testRunnerLogs;
    }

    public List<String> getTestRunnerLogs() {
        return this.testRunnerLogs;
    }

    @Override
    public void setExceptionContextInfo(ExceptionTestContextImpl exceptionContext) {
        this.exceptionContext = exceptionContext;
    }

    public ExceptionTestContextImpl getExceptionContextInfo() {
        return this.exceptionContext;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public long getRunDuration() {
        return this.getEndTime().getTime() - this.getStartTime().getTime();
    }

    @Override
    public void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public AnalysisStrategy getAnalysisStrategy() {
        return this.strategy;
    }
}

