/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.com.fasterxml.jackson.databind.util;

import com.auth0.jwt.internal.com.fasterxml.jackson.core.io.SerializedString;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.BeanDescription;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.JavaType;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.type.ClassKey;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.util.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNameLookup {
    protected LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public synchronized SerializedString findRootName(Class<?> rootType, MapperConfig<?> config) {
        ClassKey key = new ClassKey(rootType);
        if (this._rootNames == null) {
            this._rootNames = new LRUMap(20, 200);
        } else {
            SerializedString name = (SerializedString)this._rootNames.get(key);
            if (name != null) {
                return name;
            }
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        String nameStr = intr.findRootName(ac);
        if (nameStr == null) {
            nameStr = rootType.getSimpleName();
        }
        SerializedString name = new SerializedString(nameStr);
        this._rootNames.put(key, name);
        return name;
    }
}

