/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTAlgorithmException;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.ObjectMapper;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.auth0.jwt.internal.com.fasterxml.jackson.databind.node.ObjectNode;
import com.auth0.jwt.internal.org.apache.commons.codec.binary.Base64;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.auth0.jwt.internal.org.apache.commons.lang3.Validate;
import com.auth0.jwt.internal.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JWTSigner {
    private byte[] secret;
    private PrivateKey privateKey;
    protected static final Algorithm DEFAULT_ALGORITHM;

    public JWTSigner(String secret) {
        this(secret.getBytes());
    }

    public JWTSigner(byte[] secret) {
        Validate.notNull(secret);
        this.secret = secret;
    }

    public JWTSigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String sign(Map<String, Object> claims, Options options) {
        Validate.notNull(claims);
        Algorithm algorithm = options != null && options.algorithm != null ? options.algorithm : DEFAULT_ALGORITHM;
        ArrayList<String> segments = new ArrayList<String>();
        try {
            segments.add(this.encodedHeader(algorithm));
            segments.add(this.encodedPayload(claims, options));
            segments.add(this.encodedSignature(this.join(segments, "."), algorithm));
            return this.join(segments, ".");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public String sign(Map<String, Object> claims) {
        Validate.notNull(claims);
        return this.sign(claims, null);
    }

    private String encodedHeader(Algorithm algorithm) throws UnsupportedEncodingException {
        Validate.notNull(algorithm);
        ObjectNode header = JsonNodeFactory.instance.objectNode();
        header.put("typ", "JWT");
        header.put("alg", algorithm.name());
        return this.base64UrlEncode(header.toString().getBytes("UTF-8"));
    }

    private String encodedPayload(Map<String, Object> _claims, Options options) throws IOException {
        HashMap<String, Object> claims = new HashMap<String, Object>(_claims);
        this.enforceStringOrURI(claims, "iss");
        this.enforceStringOrURI(claims, "sub");
        this.enforceStringOrURICollection(claims, "aud");
        this.enforceIntDate(claims, "exp");
        this.enforceIntDate(claims, "nbf");
        this.enforceIntDate(claims, "iat");
        this.enforceString(claims, "jti");
        if (options != null) {
            this.processPayloadOptions(claims, options);
        }
        String payload = new ObjectMapper().writeValueAsString(claims);
        return this.base64UrlEncode(payload.getBytes("UTF-8"));
    }

    private void processPayloadOptions(Map<String, Object> claims, Options options) {
        Validate.notNull(claims);
        Validate.notNull(options);
        long now = System.currentTimeMillis() / 1000L;
        if (options.expirySeconds != null) {
            claims.put("exp", now + (long)options.expirySeconds.intValue());
        }
        if (options.notValidBeforeLeeway != null) {
            claims.put("nbf", now - (long)options.notValidBeforeLeeway.intValue());
        }
        if (options.isIssuedAt()) {
            claims.put("iat", now);
        }
        if (options.isJwtId()) {
            claims.put("jti", UUID.randomUUID().toString());
        }
    }

    private void enforceIntDate(Map<String, Object> claims, String claimName) {
        Validate.notNull(claims);
        Validate.notNull(claimName);
        Object value = this.handleNullValue(claims, claimName);
        if (value == null) {
            return;
        }
        if (!(value instanceof Number)) {
            throw new IllegalStateException(String.format("Claim '%s' is invalid: must be an instance of Number", claimName));
        }
        long longValue = ((Number)value).longValue();
        if (longValue < 0L) {
            throw new IllegalStateException(String.format("Claim '%s' is invalid: must be non-negative", claimName));
        }
        claims.put(claimName, longValue);
    }

    private void enforceStringOrURICollection(Map<String, Object> claims, String claimName) {
        Object values = this.handleNullValue(claims, claimName);
        if (values == null) {
            return;
        }
        if (values instanceof Collection) {
            for (Object value : (Collection)values) {
                String error = this.checkStringOrURI(value);
                if (error == null) continue;
                throw new IllegalStateException(String.format("Claim 'aud' element is invalid: %s", error));
            }
        } else {
            this.enforceStringOrURI(claims, "aud");
        }
    }

    private void enforceStringOrURI(Map<String, Object> claims, String claimName) {
        Object value = this.handleNullValue(claims, claimName);
        if (value == null) {
            return;
        }
        String error = this.checkStringOrURI(value);
        if (error != null) {
            throw new IllegalStateException(String.format("Claim '%s' is invalid: %s", claimName, error));
        }
    }

    private void enforceString(Map<String, Object> claims, String claimName) {
        Object value = this.handleNullValue(claims, claimName);
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new IllegalStateException(String.format("Claim '%s' is invalid: not a string", claimName));
        }
    }

    private Object handleNullValue(Map<String, Object> claims, String claimName) {
        if (!claims.containsKey(claimName)) {
            return null;
        }
        Object value = claims.get(claimName);
        if (value == null) {
            claims.remove(claimName);
            return null;
        }
        return value;
    }

    private String checkStringOrURI(Object value) {
        if (!(value instanceof String)) {
            return "not a string";
        }
        String stringOrUri = (String)value;
        if (!stringOrUri.contains(":")) {
            return null;
        }
        try {
            new URI(stringOrUri);
        }
        catch (URISyntaxException e) {
            return "not a valid URI";
        }
        return null;
    }

    private String encodedSignature(String signingInput, Algorithm algorithm) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, JWTAlgorithmException {
        Validate.notNull(signingInput);
        Validate.notNull(algorithm);
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return this.base64UrlEncode(JWTSigner.signHmac(algorithm, signingInput, this.secret));
            }
            case RS256: 
            case RS384: 
            case RS512: {
                return this.base64UrlEncode(JWTSigner.signRs(algorithm, signingInput, this.privateKey));
            }
        }
        throw new JWTAlgorithmException("Unsupported signing method");
    }

    private String base64UrlEncode(byte[] str) {
        Validate.notNull(str);
        return new String(Base64.encodeBase64URLSafe(str));
    }

    private static byte[] signHmac(Algorithm algorithm, String msg, byte[] secret) throws NoSuchAlgorithmException, InvalidKeyException {
        Validate.notNull(algorithm);
        Validate.notNull(msg);
        Validate.notNull(secret);
        Mac mac = Mac.getInstance(algorithm.getValue());
        mac.init(new SecretKeySpec(secret, algorithm.getValue()));
        return mac.doFinal(msg.getBytes());
    }

    private static byte[] signRs(Algorithm algorithm, String msg, PrivateKey privateKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Validate.notNull(algorithm);
        Validate.notNull(msg);
        Validate.notNull(privateKey);
        byte[] messageBytes = msg.getBytes();
        Signature signature = Signature.getInstance(algorithm.getValue(), "BC");
        signature.initSign(privateKey);
        signature.update(messageBytes);
        return signature.sign();
    }

    private String join(List<String> input, String separator) {
        Validate.notNull(input);
        Validate.notNull(separator);
        return StringUtils.join(input.iterator(), separator);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        DEFAULT_ALGORITHM = Algorithm.HS256;
    }

    public static class Options {
        private Algorithm algorithm;
        private Integer expirySeconds;
        private Integer notValidBeforeLeeway;
        private boolean issuedAt;
        private boolean jwtId;

        public Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public Options setAlgorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Integer getExpirySeconds() {
            return this.expirySeconds;
        }

        public Options setExpirySeconds(Integer expirySeconds) {
            this.expirySeconds = expirySeconds;
            return this;
        }

        public Integer getNotValidBeforeLeeway() {
            return this.notValidBeforeLeeway;
        }

        public Options setNotValidBeforeLeeway(Integer notValidBeforeLeeway) {
            this.notValidBeforeLeeway = notValidBeforeLeeway;
            return this;
        }

        public boolean isIssuedAt() {
            return this.issuedAt;
        }

        public Options setIssuedAt(boolean issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public boolean isJwtId() {
            return this.jwtId;
        }

        public Options setJwtId(boolean jwtId) {
            this.jwtId = jwtId;
            return this;
        }
    }
}

