/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceRepository {
    private final boolean mFramework;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> mItems = Maps.newEnumMap(ResourceType.class);
    private final RepositoryMerger mConsumer = new RepositoryMerger();

    public ResourceRepository(boolean isFramework) {
        this.mFramework = isFramework;
    }

    @NonNull
    MergeConsumer<ResourceItem> getMergeConsumer() {
        return this.mConsumer;
    }

    @NonNull
    Map<ResourceType, ListMultimap<String, ResourceItem>> getItems() {
        return this.mItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<ResourceItem> getResourceItem(@NonNull ResourceType resourceType, @NonNull String resourceName) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            ListMultimap<String, ResourceItem> map2 = this.mItems.get(resourceType);
            if (map2 != null) {
                return map2.get((Object)resourceName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<String> getItemsOfType(@NonNull ResourceType type) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            Multimap map2 = (Multimap)this.mItems.get(type);
            if (map2 == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(map2.keySet());
        }
    }

    public boolean hasResourceItem(@NonNull String url) {
        if (url.startsWith("?")) {
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
                return this.hasResourceItem(url);
            }
            int colon = url.indexOf(58);
            if (colon != -1) {
                if (remainder.indexOf(47, colon) == -1) {
                    remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                }
                url = "@" + remainder;
                return this.hasResourceItem(url);
            }
            int slash = url.indexOf(47);
            if (slash == -1) {
                url = "@attr/" + remainder;
                return this.hasResourceItem(url);
            }
        }
        if (!url.startsWith("@")) {
            return false;
        }
        assert (url.startsWith("@") || url.startsWith("?")) : url;
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd != -1) {
            String typeName;
            ResourceType type;
            int nameBegin = typeEnd + 1;
            int typeBegin = url.startsWith("@+") ? 2 : 1;
            int colon = url.lastIndexOf(58, typeEnd);
            if (colon != -1) {
                typeBegin = colon + 1;
            }
            if ((type = ResourceType.getEnum((String)(typeName = url.substring(typeBegin, typeEnd)))) != null) {
                String name = url.substring(nameBegin);
                return this.hasResourceItem(type, name);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourceItem(@NonNull ResourceType resourceType, @NonNull String resourceName) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            ListMultimap<String, ResourceItem> map2 = this.mItems.get(resourceType);
            if (map2 != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                List itemList = map2.get((Object)resourceName);
                return itemList != null && !itemList.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourcesOfType(@NonNull ResourceType resourceType) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            ListMultimap<String, ResourceItem> map2 = this.mItems.get(resourceType);
            return map2 != null && !map2.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<ResourceType> getAvailableResourceTypes() {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            return Lists.newArrayList(this.mItems.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourceFile getMatchingFile(@NonNull String name, @NonNull ResourceType type, @NonNull FolderConfiguration config) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            ListMultimap<String, ResourceItem> typeItems = this.mItems.get(type);
            if (typeItems == null) {
                return null;
            }
            List matchingItems = typeItems.get((Object)name);
            if (matchingItems == null || matchingItems.isEmpty()) {
                return null;
            }
            ResourceItem match = (ResourceItem)config.findMatchingConfigurable(matchingItems);
            if (match != null) {
                return (ResourceFile)match.getSource();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Map<ResourceType, Map<String, ResourceValue>> getConfiguredResources(@NonNull FolderConfiguration referenceConfig) {
        EnumMap map = Maps.newEnumMap(ResourceType.class);
        Map<ResourceType, ListMultimap<String, ResourceItem>> map2 = this.mItems;
        synchronized (map2) {
            for (ResourceType key : ResourceType.values()) {
                map.put(key, this.getConfiguredResource(key, referenceConfig));
            }
        }
        return map;
    }

    @NonNull
    private Map<String, ResourceValue> getConfiguredResource(@NonNull ResourceType type, @NonNull FolderConfiguration referenceConfig) {
        ListMultimap<String, ResourceItem> items = this.mItems.get(type);
        if (items == null) {
            return Maps.newHashMap();
        }
        Set keys = items.keySet();
        HashMap map = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (String key : keys) {
            List keyItems = items.get((Object)key);
            ResourceItem match = (ResourceItem)referenceConfig.findMatchingConfigurable(keyItems);
            ResourceValue value = match.getResourceValue(this.mFramework);
            if (value == null) continue;
            map.put(match.getName(), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItem(@NonNull ResourceItem item) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            ArrayListMultimap map2 = this.mItems.get(item.getType());
            if (map2 == null) {
                map2 = ArrayListMultimap.create();
                this.mItems.put(item.getType(), (ListMultimap<String, ResourceItem>)map2);
            }
            if (!map2.containsValue((Object)item)) {
                map2.put((Object)item.getName(), (Object)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItem(@NonNull ResourceItem removedItem) {
        Map<ResourceType, ListMultimap<String, ResourceItem>> map = this.mItems;
        synchronized (map) {
            Multimap map2 = (Multimap)this.mItems.get(removedItem.getType());
            if (map2 != null) {
                map2.remove((Object)removedItem.getName(), (Object)removedItem);
            }
        }
    }

    private class RepositoryMerger
    implements MergeConsumer<ResourceItem> {
        private RepositoryMerger() {
        }

        @Override
        public void start() throws MergeConsumer.ConsumerException {
        }

        @Override
        public void end() throws MergeConsumer.ConsumerException {
        }

        @Override
        public void addItem(@NonNull ResourceItem item) throws MergeConsumer.ConsumerException {
            if (item.isTouched()) {
                ResourceRepository.this.addItem(item);
            }
        }

        @Override
        public void removeItem(@NonNull ResourceItem removedItem, @Nullable ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
            ResourceRepository.this.removeItem(removedItem);
        }
    }
}

