/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.DataFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class DataItem<F extends DataFile> {
    private static final int MASK_TOUCHED = 1;
    private static final int MASK_REMOVED = 2;
    private static final int MASK_WRITTEN = 16;
    private final String mName;
    private F mSource;
    private int mStatus = 0;

    DataItem(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public F getSource() {
        return this.mSource;
    }

    void setSource(F sourceFile) {
        this.mSource = sourceFile;
    }

    DataItem resetStatus() {
        this.mStatus = 0;
        return this;
    }

    DataItem resetStatusToWritten() {
        this.mStatus = 16;
        return this;
    }

    DataItem resetStatusToTouched() {
        this.mStatus = 1;
        return this;
    }

    DataItem setWritten() {
        this.mStatus |= 0x10;
        return this;
    }

    DataItem setRemoved() {
        this.mStatus |= 2;
        return this;
    }

    DataItem setTouched() {
        this.mStatus |= 1;
        this.wasTouched();
        return this;
    }

    boolean isRemoved() {
        return (this.mStatus & 2) != 0;
    }

    boolean isTouched() {
        return (this.mStatus & 1) != 0;
    }

    boolean isWritten() {
        return (this.mStatus & 0x10) != 0;
    }

    protected int getStatus() {
        return this.mStatus;
    }

    String getKey() {
        return this.mName;
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    Node getAdoptedNode(Document document) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataItem dataItem = (DataItem)o;
        if (!this.mName.equals(dataItem.mName)) {
            return false;
        }
        return !(this.mSource == null ? dataItem.mSource != null : !this.mSource.equals(dataItem.mSource));
    }

    public int hashCode() {
        int result = this.mName.hashCode();
        result = 31 * result + (this.mSource != null ? this.mSource.hashCode() : 0);
        return result;
    }

    protected void wasTouched() {
    }
}

