/*
 * Decompiled with CFR 0.152.
 */
package com.android.xml;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class AndroidManifest {
    public static final String NODE_MANIFEST = "manifest";
    public static final String NODE_APPLICATION = "application";
    public static final String NODE_ACTIVITY = "activity";
    public static final String NODE_ACTIVITY_ALIAS = "activity-alias";
    public static final String NODE_SERVICE = "service";
    public static final String NODE_RECEIVER = "receiver";
    public static final String NODE_PROVIDER = "provider";
    public static final String NODE_INTENT = "intent-filter";
    public static final String NODE_ACTION = "action";
    public static final String NODE_CATEGORY = "category";
    public static final String NODE_USES_SDK = "uses-sdk";
    public static final String NODE_PERMISSION = "permission";
    public static final String NODE_PERMISSION_TREE = "permission-tree";
    public static final String NODE_PERMISSION_GROUP = "permission-group";
    public static final String NODE_USES_PERMISSION = "uses-permission";
    public static final String NODE_INSTRUMENTATION = "instrumentation";
    public static final String NODE_USES_LIBRARY = "uses-library";
    public static final String NODE_SUPPORTS_SCREENS = "supports-screens";
    public static final String NODE_COMPATIBLE_SCREENS = "compatible-screens";
    public static final String NODE_USES_CONFIGURATION = "uses-configuration";
    public static final String NODE_USES_FEATURE = "uses-feature";
    public static final String NODE_METADATA = "meta-data";
    public static final String NODE_DATA = "data";
    public static final String NODE_GRANT_URI_PERMISSION = "grant-uri-permission";
    public static final String NODE_PATH_PERMISSION = "path-permission";
    public static final String NODE_SUPPORTS_GL_TEXTURE = "supports-gl-texture";
    public static final String ATTRIBUTE_PACKAGE = "package";
    public static final String ATTRIBUTE_VERSIONCODE = "versionCode";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_REQUIRED = "required";
    public static final String ATTRIBUTE_GLESVERSION = "glEsVersion";
    public static final String ATTRIBUTE_PROCESS = "process";
    public static final String ATTRIBUTE_DEBUGGABLE = "debuggable";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_MIN_SDK_VERSION = "minSdkVersion";
    public static final String ATTRIBUTE_TARGET_SDK_VERSION = "targetSdkVersion";
    public static final String ATTRIBUTE_TARGET_PACKAGE = "targetPackage";
    public static final String ATTRIBUTE_TARGET_ACTIVITY = "targetActivity";
    public static final String ATTRIBUTE_MANAGE_SPACE_ACTIVITY = "manageSpaceActivity";
    public static final String ATTRIBUTE_EXPORTED = "exported";
    public static final String ATTRIBUTE_RESIZEABLE = "resizeable";
    public static final String ATTRIBUTE_ANYDENSITY = "anyDensity";
    public static final String ATTRIBUTE_SMALLSCREENS = "smallScreens";
    public static final String ATTRIBUTE_NORMALSCREENS = "normalScreens";
    public static final String ATTRIBUTE_LARGESCREENS = "largeScreens";
    public static final String ATTRIBUTE_REQ_5WAYNAV = "reqFiveWayNav";
    public static final String ATTRIBUTE_REQ_NAVIGATION = "reqNavigation";
    public static final String ATTRIBUTE_REQ_HARDKEYBOARD = "reqHardKeyboard";
    public static final String ATTRIBUTE_REQ_KEYBOARDTYPE = "reqKeyboardType";
    public static final String ATTRIBUTE_REQ_TOUCHSCREEN = "reqTouchScreen";
    public static final String ATTRIBUTE_THEME = "theme";
    public static final String ATTRIBUTE_BACKUP_AGENT = "backupAgent";
    public static final String ATTRIBUTE_PARENT_ACTIVITY_NAME = "parentActivityName";

    public static IAbstractFile getManifest(IAbstractFolder projectFolder) {
        IAbstractFile file = projectFolder.getFile("AndroidManifest.xml");
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static String getPackage(IAbstractFolder projectFolder) throws XPathExpressionException, StreamException {
        IAbstractFile file = AndroidManifest.getManifest(projectFolder);
        if (file != null) {
            return AndroidManifest.getPackage(file);
        }
        return null;
    }

    public static String getPackage(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        return xPath.evaluate("/manifest/@package", new InputSource(manifestFile.getContents()));
    }

    public static boolean getDebuggable(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String value = xPath.evaluate("/manifest/application/@android:debuggable", new InputSource(manifestFile.getContents()));
        return Boolean.parseBoolean(value);
    }

    public static int getVersionCode(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String result = xPath.evaluate("/manifest/@android:versionCode", new InputSource(manifestFile.getContents()));
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean hasVersionCode(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        Node node;
        XPath xPath = AndroidXPathFactory.newXPath();
        Object result = xPath.evaluate("/manifest/@android:versionCode", new InputSource(manifestFile.getContents()), XPathConstants.NODE);
        return result != null && (node = (Node)result).getNodeValue().length() > 0;
    }

    public static Object getMinSdkVersion(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String result = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(manifestFile.getContents()));
        try {
            return Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            return result.length() > 0 ? result : null;
        }
    }

    public static Integer getTargetSdkVersion(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        String result = xPath.evaluate("/manifest/uses-sdk/@android:targetSdkVersion", new InputSource(manifestFile.getContents()));
        try {
            return Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            return result.length() > 0 ? Integer.valueOf(-1) : null;
        }
    }

    public static String getApplicationIcon(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        return xPath.evaluate("/manifest/application/@android:icon", new InputSource(manifestFile.getContents()));
    }

    public static String getApplicationLabel(IAbstractFile manifestFile) throws XPathExpressionException, StreamException {
        XPath xPath = AndroidXPathFactory.newXPath();
        return xPath.evaluate("/manifest/application/@android:label", new InputSource(manifestFile.getContents()));
    }

    public static String combinePackageAndClassName(String javaPackage, String className) {
        boolean hasDot;
        if (className == null || className.length() == 0) {
            return javaPackage;
        }
        if (javaPackage == null || javaPackage.length() == 0) {
            return className;
        }
        boolean startWithDot = className.charAt(0) == '.';
        boolean bl = hasDot = className.indexOf(46) != -1;
        if (startWithDot || !hasDot) {
            if (startWithDot) {
                return javaPackage + className;
            }
            return javaPackage + '.' + className;
        }
        return className;
    }

    public static String extractActivityName(String fullActivityName, String packageName) {
        String name;
        if (packageName != null && fullActivityName != null && packageName.length() > 0 && fullActivityName.startsWith(packageName) && (name = fullActivityName.substring(packageName.length())).length() > 0 && name.charAt(0) == '.') {
            return name;
        }
        return fullActivityName;
    }
}

