/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtils {
    public static final String XML_COMMENT_BEGIN = "<!--";
    public static final String XML_COMMENT_END = "-->";
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";

    @NonNull
    public static String lookupNamespacePrefix(@NonNull Node node, @NonNull String nsUri) {
        String defaultPrefix = "http://schemas.android.com/apk/res/android".equals(nsUri) ? "android" : "app";
        return XmlUtils.lookupNamespacePrefix(node, nsUri, defaultPrefix, true);
    }

    @NonNull
    public static String lookupNamespacePrefix(@NonNull Node node, @NonNull String nsUri, boolean create) {
        String defaultPrefix = "http://schemas.android.com/apk/res/android".equals(nsUri) ? "android" : "app";
        return XmlUtils.lookupNamespacePrefix(node, nsUri, defaultPrefix, create);
    }

    public static String lookupNamespacePrefix(@Nullable Node node, @Nullable String nsUri, @Nullable String defaultPrefix, boolean create) {
        String prefix;
        if (nsUri == null) {
            return null;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(nsUri)) {
            return "xmlns";
        }
        HashSet<String> visited = new HashSet<String>();
        Document doc = node == null ? null : node.getOwnerDocument();
        String nsPrefix = null;
        try {
            String string = nsPrefix = doc != null ? doc.lookupPrefix(nsUri) : null;
            if (nsPrefix != null) {
                return nsPrefix;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        while (node != null && node.getNodeType() == 1) {
            NamedNodeMap attrs = node.getAttributes();
            for (int n = attrs.getLength() - 1; n >= 0; --n) {
                Node attr = attrs.item(n);
                if (!"xmlns".equals(attr.getPrefix())) continue;
                String uri = attr.getNodeValue();
                nsPrefix = attr.getLocalName();
                if (nsUri.equals(uri)) {
                    return nsPrefix;
                }
                visited.add(nsPrefix);
            }
            node = node.getParentNode();
        }
        if (defaultPrefix == null) {
            return null;
        }
        String base = prefix = defaultPrefix;
        int i = 1;
        while (visited.contains(prefix)) {
            prefix = base + Integer.toString(i);
            ++i;
        }
        if (doc != null) {
            for (node = doc.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            if (node != null && create) {
                Attr attr = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix);
                attr.setValue(nsUri);
                node.getAttributes().setNamedItemNS(attr);
            }
        }
        return prefix;
    }

    @NonNull
    public static String toXmlAttributeValue(@NonNull String attrValue) {
        int n = attrValue.length();
        for (int i = 0; i < n; ++i) {
            char c = attrValue.charAt(i);
            if (c != '\"' && c != '\'' && c != '<' && c != '&') continue;
            StringBuilder sb = new StringBuilder(2 * attrValue.length());
            XmlUtils.appendXmlAttributeValue(sb, attrValue);
            return sb.toString();
        }
        return attrValue;
    }

    @NonNull
    public static String toXmlTextValue(@NonNull String textValue) {
        int n = textValue.length();
        for (int i = 0; i < n; ++i) {
            char c = textValue.charAt(i);
            if (c != '<' && c != '&') continue;
            StringBuilder sb = new StringBuilder(2 * textValue.length());
            XmlUtils.appendXmlTextValue(sb, textValue);
            return sb.toString();
        }
        return textValue;
    }

    public static void appendXmlAttributeValue(@NonNull StringBuilder sb, @NonNull String attrValue) {
        int n = attrValue.length();
        for (int i = 0; i < n; ++i) {
            char c = attrValue.charAt(i);
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
    }

    public static void appendXmlTextValue(@NonNull StringBuilder sb, @NonNull String textValue) {
        int n = textValue.length();
        for (int i = 0; i < n; ++i) {
            char c = textValue.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
    }

    public static boolean hasElementChildren(@NonNull Node node) {
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Document parseDocumentSilently(@NonNull String xml, boolean namespaceAware) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        InputSource is = new InputSource(new StringReader(xml));
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toXml(Node node, boolean preserveWhitespace) {
        StringBuilder sb = new StringBuilder(1000);
        XmlUtils.append(sb, node, 0);
        return sb.toString();
    }

    private static void append(@NonNull StringBuilder sb, @NonNull Node node, int indent) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: 
            case 11: {
                sb.append(XML_PROLOG);
                NodeList children = node.getChildNodes();
                int n = children.getLength();
                for (int i = 0; i < n; ++i) {
                    XmlUtils.append(sb, children.item(i), indent);
                }
                break;
            }
            case 3: 
            case 8: {
                if (nodeType == 8) {
                    sb.append(XML_COMMENT_BEGIN);
                }
                String text = node.getNodeValue();
                sb.append(XmlUtils.toXmlTextValue(text));
                if (nodeType != 8) break;
                sb.append(XML_COMMENT_END);
                break;
            }
            case 1: {
                int i;
                sb.append('<');
                Element element = (Element)node;
                sb.append(element.getTagName());
                NamedNodeMap attributes = element.getAttributes();
                NodeList children = element.getChildNodes();
                int childCount = children.getLength();
                int attributeCount = attributes.getLength();
                if (attributeCount > 0) {
                    for (i = 0; i < attributeCount; ++i) {
                        Node attribute = attributes.item(i);
                        sb.append(' ');
                        sb.append(attribute.getNodeName());
                        sb.append('=').append('\"');
                        sb.append(XmlUtils.toXmlAttributeValue(attribute.getNodeValue()));
                        sb.append('\"');
                    }
                }
                if (childCount == 0) {
                    sb.append('/');
                }
                sb.append('>');
                if (childCount <= 0) break;
                for (i = 0; i < childCount; ++i) {
                    Node child = children.item(i);
                    XmlUtils.append(sb, child, indent + 1);
                }
                sb.append('<').append('/');
                sb.append(element.getTagName());
                sb.append('>');
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported node type " + nodeType + ": not yet implemented");
            }
        }
    }

    public static String formatFloatAttribute(double value) {
        if (value != (double)((int)value)) {
            return String.format((Locale)null, "%.2f", value);
        }
        return Integer.toString((int)value);
    }
}

