/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.HostedZoneConfig;
import com.amazonaws.services.route53.model.VPC;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateHostedZoneRequestMarshaller
implements Marshaller<Request<CreateHostedZoneRequest>, CreateHostedZoneRequest> {
    public Request<CreateHostedZoneRequest> marshall(CreateHostedZoneRequest createHostedZoneRequest) {
        if (createHostedZoneRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHostedZoneRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateHostedZoneRequest");
            if (createHostedZoneRequest != null) {
                HostedZoneConfig hostedZoneConfig;
                VPC vPC;
                if (createHostedZoneRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(createHostedZoneRequest.getName()).endElement();
                }
                if ((vPC = createHostedZoneRequest.getVPC()) != null) {
                    xmlWriter.startElement("VPC");
                    if (vPC.getVPCRegion() != null) {
                        xmlWriter.startElement("VPCRegion").value(vPC.getVPCRegion()).endElement();
                    }
                    if (vPC.getVPCId() != null) {
                        xmlWriter.startElement("VPCId").value(vPC.getVPCId()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createHostedZoneRequest.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(createHostedZoneRequest.getCallerReference()).endElement();
                }
                if ((hostedZoneConfig = createHostedZoneRequest.getHostedZoneConfig()) != null) {
                    xmlWriter.startElement("HostedZoneConfig");
                    if (hostedZoneConfig.getComment() != null) {
                        xmlWriter.startElement("Comment").value(hostedZoneConfig.getComment()).endElement();
                    }
                    if (hostedZoneConfig.getPrivateZone() != null) {
                        xmlWriter.startElement("PrivateZone").value((Object)hostedZoneConfig.getPrivateZone()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createHostedZoneRequest.getDelegationSetId() != null) {
                    xmlWriter.startElement("DelegationSetId").value(createHostedZoneRequest.getDelegationSetId()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

