/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ArchitectureValues;
import com.amazonaws.services.ec2.model.DeviceType;
import com.amazonaws.services.ec2.model.ElasticGpuAssociation;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.HypervisorType;
import com.amazonaws.services.ec2.model.IamInstanceProfile;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceLifecycleType;
import com.amazonaws.services.ec2.model.InstanceNetworkInterface;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Monitoring;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PlatformValues;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.StateReason;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VirtualizationType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Instance
implements Serializable,
Cloneable {
    private Integer amiLaunchIndex;
    private String imageId;
    private String instanceId;
    private String instanceType;
    private String kernelId;
    private String keyName;
    private Date launchTime;
    private Monitoring monitoring;
    private Placement placement;
    private String platform;
    private String privateDnsName;
    private String privateIpAddress;
    private SdkInternalList<ProductCode> productCodes;
    private String publicDnsName;
    private String publicIpAddress;
    private String ramdiskId;
    private InstanceState state;
    private String stateTransitionReason;
    private String subnetId;
    private String vpcId;
    private String architecture;
    private SdkInternalList<InstanceBlockDeviceMapping> blockDeviceMappings;
    private String clientToken;
    private Boolean ebsOptimized;
    private Boolean enaSupport;
    private String hypervisor;
    private IamInstanceProfile iamInstanceProfile;
    private String instanceLifecycle;
    private SdkInternalList<ElasticGpuAssociation> elasticGpuAssociations;
    private SdkInternalList<InstanceNetworkInterface> networkInterfaces;
    private String rootDeviceName;
    private String rootDeviceType;
    private SdkInternalList<GroupIdentifier> securityGroups;
    private Boolean sourceDestCheck;
    private String spotInstanceRequestId;
    private String sriovNetSupport;
    private StateReason stateReason;
    private SdkInternalList<Tag> tags;
    private String virtualizationType;

    public void setAmiLaunchIndex(Integer amiLaunchIndex) {
        this.amiLaunchIndex = amiLaunchIndex;
    }

    public Integer getAmiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public Instance withAmiLaunchIndex(Integer amiLaunchIndex) {
        this.setAmiLaunchIndex(amiLaunchIndex);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Instance withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Instance withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Instance withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.withInstanceType(instanceType);
    }

    public Instance withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public Instance withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Instance withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public Instance withLaunchTime(Date launchTime) {
        this.setLaunchTime(launchTime);
        return this;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public Instance withMonitoring(Monitoring monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public Instance withPlacement(Placement placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Instance withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(PlatformValues platform) {
        this.withPlatform(platform);
    }

    public Instance withPlatform(PlatformValues platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public Instance withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public Instance withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new SdkInternalList();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        this.productCodes = new SdkInternalList(productCodes);
    }

    public Instance withProductCodes(ProductCode ... productCodes) {
        if (this.productCodes == null) {
            this.setProductCodes((Collection<ProductCode>)new SdkInternalList(productCodes.length));
        }
        for (ProductCode ele : productCodes) {
            this.productCodes.add((Object)ele);
        }
        return this;
    }

    public Instance withProductCodes(Collection<ProductCode> productCodes) {
        this.setProductCodes(productCodes);
        return this;
    }

    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public Instance withPublicDnsName(String publicDnsName) {
        this.setPublicDnsName(publicDnsName);
        return this;
    }

    public void setPublicIpAddress(String publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public Instance withPublicIpAddress(String publicIpAddress) {
        this.setPublicIpAddress(publicIpAddress);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public Instance withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public void setState(InstanceState state) {
        this.state = state;
    }

    public InstanceState getState() {
        return this.state;
    }

    public Instance withState(InstanceState state) {
        this.setState(state);
        return this;
    }

    public void setStateTransitionReason(String stateTransitionReason) {
        this.stateTransitionReason = stateTransitionReason;
    }

    public String getStateTransitionReason() {
        return this.stateTransitionReason;
    }

    public Instance withStateTransitionReason(String stateTransitionReason) {
        this.setStateTransitionReason(stateTransitionReason);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Instance withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Instance withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public Instance withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setArchitecture(ArchitectureValues architecture) {
        this.withArchitecture(architecture);
    }

    public Instance withArchitecture(ArchitectureValues architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public List<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings);
    }

    public Instance withBlockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings((Collection<InstanceBlockDeviceMapping>)new SdkInternalList(blockDeviceMappings.length));
        }
        for (InstanceBlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add((Object)ele);
        }
        return this;
    }

    public Instance withBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public Instance withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public Instance withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setEnaSupport(Boolean enaSupport) {
        this.enaSupport = enaSupport;
    }

    public Boolean getEnaSupport() {
        return this.enaSupport;
    }

    public Instance withEnaSupport(Boolean enaSupport) {
        this.setEnaSupport(enaSupport);
        return this;
    }

    public Boolean isEnaSupport() {
        return this.enaSupport;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public Instance withHypervisor(String hypervisor) {
        this.setHypervisor(hypervisor);
        return this;
    }

    public void setHypervisor(HypervisorType hypervisor) {
        this.withHypervisor(hypervisor);
    }

    public Instance withHypervisor(HypervisorType hypervisor) {
        this.hypervisor = hypervisor.toString();
        return this;
    }

    public void setIamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public IamInstanceProfile getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public Instance withIamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public void setInstanceLifecycle(String instanceLifecycle) {
        this.instanceLifecycle = instanceLifecycle;
    }

    public String getInstanceLifecycle() {
        return this.instanceLifecycle;
    }

    public Instance withInstanceLifecycle(String instanceLifecycle) {
        this.setInstanceLifecycle(instanceLifecycle);
        return this;
    }

    public void setInstanceLifecycle(InstanceLifecycleType instanceLifecycle) {
        this.withInstanceLifecycle(instanceLifecycle);
    }

    public Instance withInstanceLifecycle(InstanceLifecycleType instanceLifecycle) {
        this.instanceLifecycle = instanceLifecycle.toString();
        return this;
    }

    public List<ElasticGpuAssociation> getElasticGpuAssociations() {
        if (this.elasticGpuAssociations == null) {
            this.elasticGpuAssociations = new SdkInternalList();
        }
        return this.elasticGpuAssociations;
    }

    public void setElasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations) {
        if (elasticGpuAssociations == null) {
            this.elasticGpuAssociations = null;
            return;
        }
        this.elasticGpuAssociations = new SdkInternalList(elasticGpuAssociations);
    }

    public Instance withElasticGpuAssociations(ElasticGpuAssociation ... elasticGpuAssociations) {
        if (this.elasticGpuAssociations == null) {
            this.setElasticGpuAssociations((Collection<ElasticGpuAssociation>)new SdkInternalList(elasticGpuAssociations.length));
        }
        for (ElasticGpuAssociation ele : elasticGpuAssociations) {
            this.elasticGpuAssociations.add((Object)ele);
        }
        return this;
    }

    public Instance withElasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations) {
        this.setElasticGpuAssociations(elasticGpuAssociations);
        return this;
    }

    public List<InstanceNetworkInterface> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList(networkInterfaces);
    }

    public Instance withNetworkInterfaces(InstanceNetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces((Collection<InstanceNetworkInterface>)new SdkInternalList(networkInterfaces.length));
        }
        for (InstanceNetworkInterface ele : networkInterfaces) {
            this.networkInterfaces.add((Object)ele);
        }
        return this;
    }

    public Instance withNetworkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Instance withRootDeviceName(String rootDeviceName) {
        this.setRootDeviceName(rootDeviceName);
        return this;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public Instance withRootDeviceType(String rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    public void setRootDeviceType(DeviceType rootDeviceType) {
        this.withRootDeviceType(rootDeviceType);
    }

    public Instance withRootDeviceType(DeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType.toString();
        return this;
    }

    public List<GroupIdentifier> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList(securityGroups);
    }

    public Instance withSecurityGroups(GroupIdentifier ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups((Collection<GroupIdentifier>)new SdkInternalList(securityGroups.length));
        }
        for (GroupIdentifier ele : securityGroups) {
            this.securityGroups.add((Object)ele);
        }
        return this;
    }

    public Instance withSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public Instance withSourceDestCheck(Boolean sourceDestCheck) {
        this.setSourceDestCheck(sourceDestCheck);
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSpotInstanceRequestId(String spotInstanceRequestId) {
        this.spotInstanceRequestId = spotInstanceRequestId;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public Instance withSpotInstanceRequestId(String spotInstanceRequestId) {
        this.setSpotInstanceRequestId(spotInstanceRequestId);
        return this;
    }

    public void setSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
    }

    public String getSriovNetSupport() {
        return this.sriovNetSupport;
    }

    public Instance withSriovNetSupport(String sriovNetSupport) {
        this.setSriovNetSupport(sriovNetSupport);
        return this;
    }

    public void setStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public Instance withStateReason(StateReason stateReason) {
        this.setStateReason(stateReason);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public Instance withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public Instance withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public Instance withVirtualizationType(String virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public void setVirtualizationType(VirtualizationType virtualizationType) {
        this.withVirtualizationType(virtualizationType);
    }

    public Instance withVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmiLaunchIndex() != null) {
            sb.append("AmiLaunchIndex: ").append(this.getAmiLaunchIndex()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getLaunchTime() != null) {
            sb.append("LaunchTime: ").append(this.getLaunchTime()).append(",");
        }
        if (this.getMonitoring() != null) {
            sb.append("Monitoring: ").append(this.getMonitoring()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName()).append(",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.getPrivateIpAddress()).append(",");
        }
        if (this.getProductCodes() != null) {
            sb.append("ProductCodes: ").append(this.getProductCodes()).append(",");
        }
        if (this.getPublicDnsName() != null) {
            sb.append("PublicDnsName: ").append(this.getPublicDnsName()).append(",");
        }
        if (this.getPublicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(this.getPublicIpAddress()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateTransitionReason() != null) {
            sb.append("StateTransitionReason: ").append(this.getStateTransitionReason()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getEnaSupport() != null) {
            sb.append("EnaSupport: ").append(this.getEnaSupport()).append(",");
        }
        if (this.getHypervisor() != null) {
            sb.append("Hypervisor: ").append(this.getHypervisor()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getInstanceLifecycle() != null) {
            sb.append("InstanceLifecycle: ").append(this.getInstanceLifecycle()).append(",");
        }
        if (this.getElasticGpuAssociations() != null) {
            sb.append("ElasticGpuAssociations: ").append(this.getElasticGpuAssociations()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getRootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.getRootDeviceName()).append(",");
        }
        if (this.getRootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(this.getRootDeviceType()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.getSourceDestCheck()).append(",");
        }
        if (this.getSpotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(this.getSpotInstanceRequestId()).append(",");
        }
        if (this.getSriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.getSriovNetSupport()).append(",");
        }
        if (this.getStateReason() != null) {
            sb.append("StateReason: ").append(this.getStateReason()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVirtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.getVirtualizationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.getAmiLaunchIndex() == null ^ this.getAmiLaunchIndex() == null) {
            return false;
        }
        if (other.getAmiLaunchIndex() != null && !other.getAmiLaunchIndex().equals(this.getAmiLaunchIndex())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getLaunchTime() == null ^ this.getLaunchTime() == null) {
            return false;
        }
        if (other.getLaunchTime() != null && !other.getLaunchTime().equals(this.getLaunchTime())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !other.getProductCodes().equals(this.getProductCodes())) {
            return false;
        }
        if (other.getPublicDnsName() == null ^ this.getPublicDnsName() == null) {
            return false;
        }
        if (other.getPublicDnsName() != null && !other.getPublicDnsName().equals(this.getPublicDnsName())) {
            return false;
        }
        if (other.getPublicIpAddress() == null ^ this.getPublicIpAddress() == null) {
            return false;
        }
        if (other.getPublicIpAddress() != null && !other.getPublicIpAddress().equals(this.getPublicIpAddress())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateTransitionReason() == null ^ this.getStateTransitionReason() == null) {
            return false;
        }
        if (other.getStateTransitionReason() != null && !other.getStateTransitionReason().equals(this.getStateTransitionReason())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getEnaSupport() == null ^ this.getEnaSupport() == null) {
            return false;
        }
        if (other.getEnaSupport() != null && !other.getEnaSupport().equals(this.getEnaSupport())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        if (other.getHypervisor() != null && !other.getHypervisor().equals(this.getHypervisor())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getInstanceLifecycle() == null ^ this.getInstanceLifecycle() == null) {
            return false;
        }
        if (other.getInstanceLifecycle() != null && !other.getInstanceLifecycle().equals(this.getInstanceLifecycle())) {
            return false;
        }
        if (other.getElasticGpuAssociations() == null ^ this.getElasticGpuAssociations() == null) {
            return false;
        }
        if (other.getElasticGpuAssociations() != null && !other.getElasticGpuAssociations().equals(this.getElasticGpuAssociations())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getRootDeviceName() == null ^ this.getRootDeviceName() == null) {
            return false;
        }
        if (other.getRootDeviceName() != null && !other.getRootDeviceName().equals(this.getRootDeviceName())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSourceDestCheck() == null ^ this.getSourceDestCheck() == null) {
            return false;
        }
        if (other.getSourceDestCheck() != null && !other.getSourceDestCheck().equals(this.getSourceDestCheck())) {
            return false;
        }
        if (other.getSpotInstanceRequestId() == null ^ this.getSpotInstanceRequestId() == null) {
            return false;
        }
        if (other.getSpotInstanceRequestId() != null && !other.getSpotInstanceRequestId().equals(this.getSpotInstanceRequestId())) {
            return false;
        }
        if (other.getSriovNetSupport() == null ^ this.getSriovNetSupport() == null) {
            return false;
        }
        if (other.getSriovNetSupport() != null && !other.getSriovNetSupport().equals(this.getSriovNetSupport())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        return other.getVirtualizationType() == null || other.getVirtualizationType().equals(this.getVirtualizationType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmiLaunchIndex() == null ? 0 : this.getAmiLaunchIndex().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTime() == null ? 0 : this.getLaunchTime().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : this.getProductCodes().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDnsName() == null ? 0 : this.getPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIpAddress() == null ? 0 : this.getPublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateTransitionReason() == null ? 0 : this.getStateTransitionReason().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getEnaSupport() == null ? 0 : this.getEnaSupport().hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceLifecycle() == null ? 0 : this.getInstanceLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getElasticGpuAssociations() == null ? 0 : this.getElasticGpuAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceName() == null ? 0 : this.getRootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDestCheck() == null ? 0 : this.getSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getSpotInstanceRequestId() == null ? 0 : this.getSpotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getSriovNetSupport() == null ? 0 : this.getSriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        return hashCode;
    }

    public Instance clone() {
        try {
            return (Instance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

