/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DiskImageDescription;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DiskImageDescriptionStaxUnmarshaller
implements Unmarshaller<DiskImageDescription, StaxUnmarshallerContext> {
    private static DiskImageDescriptionStaxUnmarshaller instance;

    public DiskImageDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        DiskImageDescription diskImageDescription = new DiskImageDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return diskImageDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("format", targetDepth)) {
                    diskImageDescription.setFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("size", targetDepth)) {
                    diskImageDescription.setSize(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("importManifestUrl", targetDepth)) {
                    diskImageDescription.setImportManifestUrl(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("checksum", targetDepth)) continue;
                diskImageDescription.setChecksum(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return diskImageDescription;
    }

    public static DiskImageDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DiskImageDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

