/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.PropagatingVgw;
import com.amazonaws.services.ec2.model.Route;
import com.amazonaws.services.ec2.model.RouteTableAssociation;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RouteTable
implements Serializable,
Cloneable {
    private String routeTableId;
    private String vpcId;
    private ListWithAutoConstructFlag<Route> routes;
    private ListWithAutoConstructFlag<RouteTableAssociation> associations;
    private ListWithAutoConstructFlag<Tag> tags;
    private ListWithAutoConstructFlag<PropagatingVgw> propagatingVgws;

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public RouteTable withRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public RouteTable withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ListWithAutoConstructFlag();
            this.routes.setAutoConstruct(true);
        }
        return this.routes;
    }

    public void setRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
            return;
        }
        ListWithAutoConstructFlag routesCopy = new ListWithAutoConstructFlag(routes.size());
        routesCopy.addAll(routes);
        this.routes = routesCopy;
    }

    public RouteTable withRoutes(Route ... routes) {
        if (this.getRoutes() == null) {
            this.setRoutes(new ArrayList<Route>(routes.length));
        }
        for (Route value : routes) {
            this.getRoutes().add(value);
        }
        return this;
    }

    public RouteTable withRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
        } else {
            ListWithAutoConstructFlag routesCopy = new ListWithAutoConstructFlag(routes.size());
            routesCopy.addAll(routes);
            this.routes = routesCopy;
        }
        return this;
    }

    public List<RouteTableAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new ListWithAutoConstructFlag();
            this.associations.setAutoConstruct(true);
        }
        return this.associations;
    }

    public void setAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        ListWithAutoConstructFlag associationsCopy = new ListWithAutoConstructFlag(associations.size());
        associationsCopy.addAll(associations);
        this.associations = associationsCopy;
    }

    public RouteTable withAssociations(RouteTableAssociation ... associations) {
        if (this.getAssociations() == null) {
            this.setAssociations(new ArrayList<RouteTableAssociation>(associations.length));
        }
        for (RouteTableAssociation value : associations) {
            this.getAssociations().add(value);
        }
        return this;
    }

    public RouteTable withAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
        } else {
            ListWithAutoConstructFlag associationsCopy = new ListWithAutoConstructFlag(associations.size());
            associationsCopy.addAll(associations);
            this.associations = associationsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RouteTable withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RouteTable withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public List<PropagatingVgw> getPropagatingVgws() {
        if (this.propagatingVgws == null) {
            this.propagatingVgws = new ListWithAutoConstructFlag();
            this.propagatingVgws.setAutoConstruct(true);
        }
        return this.propagatingVgws;
    }

    public void setPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
        if (propagatingVgws == null) {
            this.propagatingVgws = null;
            return;
        }
        ListWithAutoConstructFlag propagatingVgwsCopy = new ListWithAutoConstructFlag(propagatingVgws.size());
        propagatingVgwsCopy.addAll(propagatingVgws);
        this.propagatingVgws = propagatingVgwsCopy;
    }

    public RouteTable withPropagatingVgws(PropagatingVgw ... propagatingVgws) {
        if (this.getPropagatingVgws() == null) {
            this.setPropagatingVgws(new ArrayList<PropagatingVgw>(propagatingVgws.length));
        }
        for (PropagatingVgw value : propagatingVgws) {
            this.getPropagatingVgws().add(value);
        }
        return this;
    }

    public RouteTable withPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
        if (propagatingVgws == null) {
            this.propagatingVgws = null;
        } else {
            ListWithAutoConstructFlag propagatingVgwsCopy = new ListWithAutoConstructFlag(propagatingVgws.size());
            propagatingVgwsCopy.addAll(propagatingVgws);
            this.propagatingVgws = propagatingVgwsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRouteTableId() != null) {
            sb.append("RouteTableId: " + this.getRouteTableId() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getRoutes() != null) {
            sb.append("Routes: " + this.getRoutes() + ",");
        }
        if (this.getAssociations() != null) {
            sb.append("Associations: " + this.getAssociations() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getPropagatingVgws() != null) {
            sb.append("PropagatingVgws: " + this.getPropagatingVgws());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRouteTableId() == null ? 0 : this.getRouteTableId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getRoutes() == null ? 0 : this.getRoutes().hashCode());
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : this.getAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPropagatingVgws() == null ? 0 : this.getPropagatingVgws().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        if (other.getRouteTableId() == null ^ this.getRouteTableId() == null) {
            return false;
        }
        if (other.getRouteTableId() != null && !other.getRouteTableId().equals(this.getRouteTableId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getRoutes() == null ^ this.getRoutes() == null) {
            return false;
        }
        if (other.getRoutes() != null && !other.getRoutes().equals(this.getRoutes())) {
            return false;
        }
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !other.getAssociations().equals(this.getAssociations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPropagatingVgws() == null ^ this.getPropagatingVgws() == null) {
            return false;
        }
        return other.getPropagatingVgws() == null || other.getPropagatingVgws().equals(this.getPropagatingVgws());
    }

    public RouteTable clone() {
        try {
            return (RouteTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

