/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.InstanceStatusDetails;
import com.amazonaws.services.ec2.model.SummaryStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceStatusSummary
implements Serializable,
Cloneable {
    private String status;
    private ListWithAutoConstructFlag<InstanceStatusDetails> details;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public InstanceStatusSummary withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(SummaryStatus status) {
        this.status = status.toString();
    }

    public InstanceStatusSummary withStatus(SummaryStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<InstanceStatusDetails> getDetails() {
        if (this.details == null) {
            this.details = new ListWithAutoConstructFlag();
            this.details.setAutoConstruct(true);
        }
        return this.details;
    }

    public void setDetails(Collection<InstanceStatusDetails> details) {
        if (details == null) {
            this.details = null;
            return;
        }
        ListWithAutoConstructFlag detailsCopy = new ListWithAutoConstructFlag(details.size());
        detailsCopy.addAll(details);
        this.details = detailsCopy;
    }

    public InstanceStatusSummary withDetails(InstanceStatusDetails ... details) {
        if (this.getDetails() == null) {
            this.setDetails(new ArrayList<InstanceStatusDetails>(details.length));
        }
        for (InstanceStatusDetails value : details) {
            this.getDetails().add(value);
        }
        return this;
    }

    public InstanceStatusSummary withDetails(Collection<InstanceStatusDetails> details) {
        if (details == null) {
            this.details = null;
        } else {
            ListWithAutoConstructFlag detailsCopy = new ListWithAutoConstructFlag(details.size());
            detailsCopy.addAll(details);
            this.details = detailsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: " + this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusSummary)) {
            return false;
        }
        InstanceStatusSummary other = (InstanceStatusSummary)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }

    public InstanceStatusSummary clone() {
        try {
            return (InstanceStatusSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

