/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.util.EC2MetadataUtils;
import org.apache.commons.logging.LogFactory;

public class InstanceMetadataRegionProvider
extends AwsRegionProvider {
    private volatile String region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRegion() throws AmazonClientException {
        if (this.region == null) {
            InstanceMetadataRegionProvider instanceMetadataRegionProvider = this;
            synchronized (instanceMetadataRegionProvider) {
                if (this.region == null) {
                    this.region = this.tryDetectRegion();
                }
            }
        }
        return this.region;
    }

    private String tryDetectRegion() {
        try {
            return EC2MetadataUtils.getEC2InstanceRegion();
        }
        catch (AmazonClientException ace) {
            LogFactory.getLog(InstanceMetadataRegionProvider.class).debug((Object)("Ignoring failure to retrieve the region: " + ace.getMessage()));
            return null;
        }
    }
}

