/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import com.aliyun.phoenix.shaded.jline.console.completer.ArgumentCompleter;
import com.aliyun.phoenix.shaded.jline.console.completer.Completer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import sqlline.DispatchCallback;
import sqlline.Quoting;
import sqlline.SqlCompleter;
import sqlline.SqlLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseConnection {
    private final SqlLine sqlLine;
    Connection connection;
    DatabaseMetaData meta;
    Quoting quoting;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private Schema schema = null;
    private Completer sqlCompleter = null;

    public DatabaseConnection(SqlLine sqlLine, String driver, String url, String username, String password) throws SQLException {
        this.sqlLine = sqlLine;
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return this.getUrl() + "";
    }

    void setCompletions(boolean skipmeta) throws SQLException, IOException {
        String startQuote = this.meta.getIdentifierQuoteString();
        boolean upper = this.meta.storesUpperCaseIdentifiers();
        if (startQuote == null || startQuote.equals("") || startQuote.equals(" ")) {
            this.quoting = this.meta.getDatabaseProductName().startsWith("MySQL") ? new Quoting('`', '`', upper) : new Quoting('\u0000', '\u0000', false);
        } else if (startQuote.equals("[")) {
            this.quoting = new Quoting('[', ']', upper);
        } else if (startQuote.length() > 1) {
            this.sqlLine.error("Identifier quote string is '" + startQuote + "'; quote strings longer than 1 char are not supported");
            this.quoting = Quoting.DEFAULT;
        } else {
            this.quoting = new Quoting(startQuote.charAt(0), startQuote.charAt(0), upper);
        }
        final String extraNameCharacters = this.meta == null || this.meta.getExtraNameCharacters() == null ? "" : this.meta.getExtraNameCharacters();
        this.sqlCompleter = new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)new ArgumentCompleter.WhitespaceArgumentDelimiter(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                char c = buffer.charAt(pos);
                if (Character.isWhitespace(c)) {
                    return true;
                }
                return !Character.isLetterOrDigit(c) && c != '_' && extraNameCharacters.indexOf(c) == -1;
            }
        }, new SqlCompleter(this.sqlLine, skipmeta));
        ((ArgumentCompleter)this.sqlCompleter).setStrict(false);
    }

    boolean connect() throws SQLException {
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return this.sqlLine.error(cnfe);
        }
        boolean foundDriver = false;
        Driver theDriver = null;
        try {
            theDriver = DriverManager.getDriver(this.url);
            foundDriver = theDriver != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!foundDriver) {
            this.sqlLine.output(this.sqlLine.loc("autoloading-known-drivers", this.url));
            this.sqlLine.registerKnownDrivers();
        }
        try {
            this.close();
        }
        catch (Exception e) {
            return this.sqlLine.error(e);
        }
        Properties info = new Properties();
        info.put("user", this.username);
        info.put("password", this.password);
        this.connection = theDriver.connect(this.url, info);
        this.meta = this.connection.getMetaData();
        try {
            this.sqlLine.debug(this.sqlLine.loc("connected", this.meta.getDatabaseProductName(), this.meta.getDatabaseProductVersion()));
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.sqlLine.debug(this.sqlLine.loc("driver", this.meta.getDriverName(), this.meta.getDriverVersion()));
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.connection.setAutoCommit(this.sqlLine.getOpts().getAutoCommit());
            this.sqlLine.autocommitStatus(this.connection);
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.sqlLine.getCommands().isolation("isolation: " + this.sqlLine.getOpts().getIsolation(), new DispatchCallback());
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.showWarnings();
        return true;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connect();
        return this.connection;
    }

    public void reconnect() throws Exception {
        this.close();
        this.getConnection();
    }

    public void close() {
        try {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.sqlLine.output(this.sqlLine.loc("closing", this.connection));
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.sqlLine.handleException(e);
            }
        }
        finally {
            this.connection = null;
            this.meta = null;
        }
    }

    public Collection<String> getTableNames(boolean force) {
        TreeSet<String> names = new TreeSet<String>();
        for (Schema.Table table : this.getSchema().getTables()) {
            names.add(table.getName());
        }
        return names;
    }

    Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    DatabaseMetaData getDatabaseMetaData() {
        return this.meta;
    }

    String getUrl() {
        return this.url;
    }

    Completer getSqlCompleter() {
        return this.sqlCompleter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Schema {
        private List<Table> tables;

        Schema() {
        }

        List<Table> getTables() {
            if (this.tables != null) {
                return this.tables;
            }
            this.tables = new LinkedList<Table>();
            try {
                ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getTables(DatabaseConnection.this.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
                try {
                    while (rs.next()) {
                        this.tables.add(new Table(rs.getString("TABLE_NAME")));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.tables;
        }

        Table getTable(String name) {
            for (Table table : this.getTables()) {
                if (!name.equalsIgnoreCase(table.getName())) continue;
                return table;
            }
            return null;
        }

        class Table {
            final String name;
            Column[] columns;

            public Table(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            class Column {
                final String name;
                boolean isPrimaryKey;

                public Column(String name) {
                    this.name = name;
                }
            }
        }
    }
}

