/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class ColorBuffer
implements Comparable {
    private final List<Object> parts = new LinkedList<Object>();
    private final boolean useColor;

    public ColorBuffer(boolean useColor) {
        this.useColor = useColor;
        this.append("");
    }

    public ColorBuffer(String str, boolean useColor) {
        this.useColor = useColor;
        this.append(str);
    }

    ColorBuffer pad(ColorBuffer str, int len) {
        for (int n = str.getVisibleLength(); n < len; ++n) {
            str.append(" ");
        }
        return this.append(str);
    }

    ColorBuffer center(String str, int len) {
        return this.append(ColorBuffer.centerString(str, len));
    }

    static String centerString(String str, int len) {
        int i;
        int n = len - str.length();
        if (n <= 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        int left = n / 2;
        int right = n - left;
        for (i = 0; i < left; ++i) {
            buf.append(' ');
        }
        buf.append(str);
        for (i = 0; i < right; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    ColorBuffer pad(String str, int len) {
        if (str == null) {
            str = "";
        }
        return this.pad(new ColorBuffer(str, false), len);
    }

    public String getColor() {
        return this.getBuffer(this.useColor);
    }

    public String getMono() {
        return this.getBuffer(false);
    }

    String getBuffer(boolean color) {
        StringBuilder buf = new StringBuilder();
        for (Object part : this.parts) {
            if (!color && part instanceof ColorAttr) continue;
            buf.append(part.toString());
        }
        return buf.toString();
    }

    public ColorBuffer truncate(int len) {
        ColorBuffer cbuff = new ColorBuffer(this.useColor);
        ColorAttr lastAttr = null;
        Iterator<Object> i = this.parts.iterator();
        while (cbuff.getVisibleLength() < len && i.hasNext()) {
            Object next = i.next();
            if (next instanceof ColorAttr) {
                lastAttr = (ColorAttr)((Object)next);
                cbuff.append((ColorAttr)((Object)next));
                continue;
            }
            String val = next.toString();
            if (cbuff.getVisibleLength() + val.length() > len) {
                int partLen = len - cbuff.getVisibleLength();
                val = val.substring(0, partLen);
            }
            cbuff.append(val);
        }
        if (lastAttr != null && lastAttr != ColorAttr.NORMAL) {
            cbuff.append(ColorAttr.NORMAL);
        }
        return cbuff;
    }

    public String toString() {
        return this.getColor();
    }

    public ColorBuffer append(String str) {
        this.parts.add(str);
        return this;
    }

    public ColorBuffer append(ColorBuffer buf) {
        this.parts.addAll(buf.parts);
        return this;
    }

    public ColorBuffer append(ColorAttr attr) {
        this.parts.add((Object)attr);
        return this;
    }

    public int getVisibleLength() {
        return this.getMono().length();
    }

    public ColorBuffer append(ColorAttr attr, String val) {
        this.parts.add((Object)attr);
        this.parts.add(val);
        this.parts.add((Object)ColorAttr.NORMAL);
        return this;
    }

    public ColorBuffer bold(String str) {
        return this.append(ColorAttr.BOLD, str);
    }

    public ColorBuffer lined(String str) {
        return this.append(ColorAttr.LINED, str);
    }

    public ColorBuffer grey(String str) {
        return this.append(ColorAttr.GREY, str);
    }

    public ColorBuffer red(String str) {
        return this.append(ColorAttr.RED, str);
    }

    public ColorBuffer blue(String str) {
        return this.append(ColorAttr.BLUE, str);
    }

    public ColorBuffer green(String str) {
        return this.append(ColorAttr.GREEN, str);
    }

    public ColorBuffer cyan(String str) {
        return this.append(ColorAttr.CYAN, str);
    }

    public ColorBuffer yellow(String str) {
        return this.append(ColorAttr.YELLOW, str);
    }

    public ColorBuffer magenta(String str) {
        return this.append(ColorAttr.MAGENTA, str);
    }

    public int compareTo(Object other) {
        return this.getMono().compareTo(((ColorBuffer)other).getMono());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ColorAttr {
        BOLD("\u001b[1m"),
        NORMAL("\u001b[m"),
        REVERS("\u001b[7m"),
        LINED("\u001b[4m"),
        GREY("\u001b[1;30m"),
        RED("\u001b[1;31m"),
        GREEN("\u001b[1;32m"),
        BLUE("\u001b[1;34m"),
        CYAN("\u001b[1;36m"),
        YELLOW("\u001b[1;33m"),
        MAGENTA("\u001b[1;35m"),
        INVISIBLE("\u001b[8m");

        private final String style;

        private ColorAttr(String style) {
            this.style = style;
        }

        public String toString() {
            return this.style;
        }
    }
}

