/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.phoenix.shaded.com.google.common.collect;

import com.aliyun.phoenix.shaded.com.google.common.annotations.GwtIncompatible;
import com.aliyun.phoenix.shaded.com.google.common.base.Preconditions;
import com.aliyun.phoenix.shaded.com.google.common.collect.Cut;
import com.aliyun.phoenix.shaded.com.google.common.collect.ForwardingCollection;
import com.aliyun.phoenix.shaded.com.google.common.collect.Range;
import com.aliyun.phoenix.shaded.com.google.common.collect.RangeSet;
import com.aliyun.phoenix.shaded.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

@GwtIncompatible(value="uses NavigableMap")
final class TreeRangeSet<C extends Comparable>
extends RangeSet<C> {
    private final NavigableMap<Cut<C>, Range<C>> rangesByLowerCut;
    private transient Set<Range<C>> asRanges;
    private transient RangeSet<C> complement;

    public static <C extends Comparable> TreeRangeSet<C> create() {
        return new TreeRangeSet<C>(new TreeMap<Cut<C>, Range<C>>());
    }

    private TreeRangeSet(NavigableMap<Cut<C>, Range<C>> rangesByLowerCut) {
        this.rangesByLowerCut = rangesByLowerCut;
    }

    @Override
    public Set<Range<C>> asRanges() {
        AsRanges result = this.asRanges;
        return result == null ? (this.asRanges = new AsRanges()) : result;
    }

    @Override
    @Nullable
    public Range<C> rangeContaining(C value) {
        Preconditions.checkNotNull(value);
        Map.Entry<Cut<C>, Range<C>> floorEntry = this.rangesByLowerCut.floorEntry(Cut.belowValue(value));
        if (floorEntry != null && floorEntry.getValue().contains(value)) {
            return floorEntry.getValue();
        }
        return null;
    }

    @Override
    public boolean encloses(Range<C> range) {
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerCut.floorEntry(range.lowerBound);
        return floorEntry != null && floorEntry.getValue().encloses(range);
    }

    @Override
    public void add(Range<C> rangeToAdd) {
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToAdd);
        if (rangeToAdd.isEmpty()) {
            return;
        }
        Cut lbToAdd = rangeToAdd.lowerBound;
        Cut ubToAdd = rangeToAdd.upperBound;
        Map.Entry entryBelowLB = this.rangesByLowerCut.lowerEntry(lbToAdd);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(lbToAdd) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(ubToAdd) >= 0) {
                    ubToAdd = rangeBelowLB.upperBound;
                }
                lbToAdd = rangeBelowLB.lowerBound;
            }
        }
        if ((entryBelowUB = this.rangesByLowerCut.floorEntry(ubToAdd)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(ubToAdd) >= 0) {
                ubToAdd = rangeBelowUB.upperBound;
            }
        }
        this.rangesByLowerCut.subMap(lbToAdd, ubToAdd).clear();
        this.replaceRangeWithSameLowerBound(new Range(lbToAdd, ubToAdd));
    }

    @Override
    public void remove(Range<C> rangeToRemove) {
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToRemove);
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry entryBelowLB = this.rangesByLowerCut.lowerEntry(rangeToRemove.lowerBound);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(rangeToRemove.lowerBound) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                    this.replaceRangeWithSameLowerBound(new Range(rangeToRemove.upperBound, rangeBelowLB.upperBound));
                }
                this.replaceRangeWithSameLowerBound(new Range(rangeBelowLB.lowerBound, rangeToRemove.lowerBound));
            }
        }
        if ((entryBelowUB = this.rangesByLowerCut.floorEntry(rangeToRemove.upperBound)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                this.replaceRangeWithSameLowerBound(new Range(rangeToRemove.upperBound, rangeBelowUB.upperBound));
            }
        }
        this.rangesByLowerCut.subMap(rangeToRemove.lowerBound, rangeToRemove.upperBound).clear();
    }

    private void replaceRangeWithSameLowerBound(Range<C> range) {
        if (range.isEmpty()) {
            this.rangesByLowerCut.remove(range.lowerBound);
        } else {
            this.rangesByLowerCut.put(range.lowerBound, range);
        }
    }

    @Override
    public RangeSet<C> complement() {
        RangeSet<C> result = this.complement;
        return result == null ? (this.complement = this.createComplement()) : result;
    }

    private RangeSet<C> createComplement() {
        return new RangeSet.StandardComplement(this);
    }

    final class AsRanges
    extends ForwardingCollection<Range<C>>
    implements Set<Range<C>> {
        AsRanges() {
        }

        @Override
        protected Collection<Range<C>> delegate() {
            return TreeRangeSet.this.rangesByLowerCut.values();
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return Sets.equalsImpl(this, o);
        }
    }
}

