/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm.io;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.utils.LoggerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class RepeatableFileInputStream
extends InputStream {
    private File file = null;
    private FileInputStream fis = null;
    private FileChannel fileChannel = null;
    private long markPos = 0L;

    public RepeatableFileInputStream(File file) throws IOException {
        this(new FileInputStream(file), file);
    }

    public RepeatableFileInputStream(FileInputStream fis) throws IOException {
        this(fis, null);
    }

    public RepeatableFileInputStream(FileInputStream fis, File file) throws IOException {
        this.file = file;
        this.fis = fis;
        this.fileChannel = fis.getChannel();
        this.markPos = this.fileChannel.position();
    }

    @Override
    public void reset() throws IOException {
        this.fileChannel.position(this.markPos);
        LoggerUtils.getLogger().trace((Object)("Reset to position " + this.markPos));
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException e) {
            throw new ClientException("Failed to mark file position", e);
        }
        LoggerUtils.getLogger().trace((Object)("File input stream marked at position " + this.markPos));
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.fis.read(b, off, len);
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }

    public File getFile() {
        return this.file;
    }
}

