/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class BucketReferer {
    private boolean allowEmptyReferer;
    private List<String> refererList;

    public BucketReferer() {
        this.allowEmptyReferer = true;
        this.refererList = new ArrayList<String>();
    }

    public BucketReferer(boolean allowEmptyReferer, List<String> refererList) {
        this.allowEmptyReferer = allowEmptyReferer;
        this.refererList = refererList;
    }

    public boolean allowEmpty() {
        return this.allowEmptyReferer;
    }

    public List<String> getRefererList() {
        return this.refererList;
    }

    public String toXmlString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<RefererConfiguration>");
        xml.append("<AllowEmptyReferer>" + String.valueOf(this.allowEmptyReferer) + "</AllowEmptyReferer>");
        xml.append("<RefererList>");
        for (String e : this.refererList) {
            xml.append("<Referer>" + e + "</Referer>");
        }
        xml.append("</RefererList>");
        xml.append("</RefererConfiguration>");
        return xml.toString();
    }

    public static BucketReferer createFromXmlRootElement(Element root) {
        Namespace ns = root.getNamespace();
        boolean allowEmptyReferer = Boolean.valueOf(root.getChildText("AllowEmptyReferer", ns));
        ArrayList<String> refererList = new ArrayList<String>();
        Element tmpElement = root.getChild("RefererList", ns);
        List tmpList = tmpElement.getChildren("Referer", ns);
        for (Element e : tmpList) {
            refererList.add(e.getText());
        }
        return new BucketReferer(allowEmptyReferer, refererList);
    }
}

