/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.iterator;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.iterator.RowIterator;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SearchRowIterator
implements RowIterator {
    private static int DEFAULT_PAGE_LIMIT = 100;
    private SyncClientInterface client;
    private Iterator<Row> rowsIterator;
    private SearchRequest searchRequest;
    private SearchResponse searchResponse;
    private long completedBytes;

    public SearchRowIterator(SyncClientInterface syncClient, SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        this.client = syncClient;
        this.completedBytes = 0L;
        this.fetchData();
    }

    private void fetchData() {
        if (null != this.searchResponse) {
            if (null == this.searchResponse.getNextToken()) {
                return;
            }
            this.searchRequest.getSearchQuery().setToken(this.searchResponse.getNextToken());
        }
        if (this.searchRequest.getSearchQuery().getLimit() == null) {
            this.searchRequest.getSearchQuery().setLimit(DEFAULT_PAGE_LIMIT);
        }
        this.searchResponse = this.client.search(this.searchRequest);
        this.completedBytes += this.searchResponse.getBodyBytes();
        if (!this.searchResponse.isAllSuccess()) {
            throw new RuntimeException("not all success");
        }
        this.rowsIterator = this.searchResponse.getRows().iterator();
    }

    private boolean isBufferHasMoreData() {
        return this.rowsIterator.hasNext();
    }

    private Row getNextFromBuffer() {
        return this.rowsIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        this.fetchData();
        return this.isBufferHasMoreData();
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getNextFromBuffer();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }

    @Override
    public long getTotalCount() {
        return this.searchResponse == null ? -1L : this.searchResponse.getTotalCount();
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }
}

