/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.groupby;

import com.alicloud.openservices.tablestore.core.protocol.SearchGroupByBuilder;
import com.alicloud.openservices.tablestore.core.utils.ValueUtil;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.FieldRange;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByType;
import com.alicloud.openservices.tablestore.model.search.sort.GroupBySorter;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GroupByHistogram
implements GroupBy {
    private final GroupByType groupByType = GroupByType.GROUP_BY_HISTOGRAM;
    private String groupByName;
    private String fieldName;
    private ColumnValue interval;
    private ColumnValue missing;
    private List<GroupBySorter> groupBySorters;
    private Long minDocCount;
    private FieldRange fieldRange;
    private List<Aggregation> subAggregations;
    private List<GroupBy> subGroupBys;

    public GroupByHistogram() {
    }

    private GroupByHistogram(Builder builder) {
        this.groupByName = builder.groupByName;
        this.fieldName = builder.fieldName;
        this.interval = builder.interval;
        this.groupBySorters = builder.groupBySorters;
        this.missing = builder.missing;
        this.minDocCount = builder.minDocCount;
        this.fieldRange = builder.fieldRange;
        this.subAggregations = builder.subAggregations;
        this.subGroupBys = builder.subGroupBys;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getGroupByName() {
        return this.groupByName;
    }

    @Override
    public GroupByType getGroupByType() {
        return this.groupByType;
    }

    @Override
    public ByteString serialize() {
        return SearchGroupByBuilder.buildGroupByHistogram(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Long getMinDocCount() {
        return this.minDocCount;
    }

    public ColumnValue getInterval() {
        return this.interval;
    }

    public ColumnValue getMissing() {
        return this.missing;
    }

    public List<GroupBySorter> getGroupBySorters() {
        return this.groupBySorters;
    }

    public FieldRange getFieldRange() {
        return this.fieldRange;
    }

    public List<Aggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public List<GroupBy> getSubGroupBys() {
        return this.subGroupBys;
    }

    public GroupByHistogram setGroupByName(String groupByName) {
        this.groupByName = groupByName;
        return this;
    }

    public GroupByHistogram setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public GroupByHistogram setMinDocCount(Long minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    public GroupByHistogram setGroupBySorters(List<GroupBySorter> groupBySorters) {
        this.groupBySorters = groupBySorters;
        return this;
    }

    public GroupByHistogram setInterval(ColumnValue interval) {
        this.interval = interval;
        return this;
    }

    public GroupByHistogram setMissing(ColumnValue missing) {
        this.missing = missing;
        return this;
    }

    public GroupByHistogram setFieldRange(FieldRange fieldRange) {
        this.fieldRange = fieldRange;
        return this;
    }

    public GroupByHistogram setSubAggregations(List<Aggregation> subAggregations) {
        this.subAggregations = subAggregations;
        return this;
    }

    public GroupByHistogram setSubGroupBys(List<GroupBy> subGroupBys) {
        this.subGroupBys = subGroupBys;
        return this;
    }

    public static final class Builder
    implements GroupByBuilder {
        private String groupByName;
        private String fieldName;
        private ColumnValue interval;
        private ColumnValue missing;
        private Long minDocCount;
        private List<GroupBySorter> groupBySorters;
        private FieldRange fieldRange;
        private List<Aggregation> subAggregations;
        private List<GroupBy> subGroupBys;

        private Builder() {
        }

        public Builder groupByName(String groupByName) {
            this.groupByName = groupByName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder interval(Object interval) {
            this.interval = ValueUtil.toColumnValue(interval);
            return this;
        }

        public Builder missing(Object missing) {
            this.missing = ValueUtil.toColumnValue(missing);
            return this;
        }

        public Builder minDocCount(Long minDocCount) {
            this.minDocCount = minDocCount;
            return this;
        }

        public Builder addGroupBySorter(GroupBySorter ... groupBySorter) {
            if (this.groupBySorters == null) {
                this.groupBySorters = new ArrayList<GroupBySorter>();
            }
            this.groupBySorters.addAll(Arrays.asList(groupBySorter));
            return this;
        }

        public Builder addGroupBySorter(List<GroupBySorter> groupBySorter) {
            if (this.groupBySorters == null) {
                this.groupBySorters = new ArrayList<GroupBySorter>();
            }
            this.groupBySorters.addAll(groupBySorter);
            return this;
        }

        public Builder addFieldRange(Object min2, Object max) {
            if (this.fieldRange == null) {
                this.fieldRange = new FieldRange(ValueUtil.toColumnValue(min2), ValueUtil.toColumnValue(max));
            }
            return this;
        }

        public Builder addSubAggregation(AggregationBuilder builder) {
            if (this.subAggregations == null) {
                this.subAggregations = new ArrayList<Aggregation>();
            }
            this.subAggregations.add(builder.build());
            return this;
        }

        public Builder addSubGroupBy(GroupByBuilder builder) {
            if (this.subGroupBys == null) {
                this.subGroupBys = new ArrayList<GroupBy>();
            }
            this.subGroupBys.add(builder.build());
            return this;
        }

        @Override
        public GroupByHistogram build() {
            return new GroupByHistogram(this);
        }
    }
}

