/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SearchRequest
implements Request {
    private String tableName;
    private String indexName;
    private SearchQuery searchQuery;
    private ColumnsToGet columnsToGet;
    private int timeoutInMillisecond = -1;
    private List<PrimaryKey> routingValues;

    public SearchRequest() {
    }

    public SearchRequest(String tableName, String indexName, SearchQuery queryBase) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.searchQuery = queryBase;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public SearchRequest setSearchQuery(SearchQuery searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public ColumnsToGet getColumnsToGet() {
        return this.columnsToGet;
    }

    public void setColumnsToGet(ColumnsToGet columnsToGet) {
        this.columnsToGet = columnsToGet;
    }

    public List<PrimaryKey> getRoutingValues() {
        return this.routingValues;
    }

    public void setRoutingValues(List<PrimaryKey> routingValues) {
        this.routingValues = routingValues;
    }

    public int getTimeoutInMillisecond() {
        return this.timeoutInMillisecond;
    }

    public void setTimeoutInMillisecond(int timeoutInMillisecond) {
        this.timeoutInMillisecond = timeoutInMillisecond;
    }

    @Override
    public String getOperationName() {
        return "Search";
    }

    public String getRequestInfo(boolean prettyFormat) {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping().serializeNulls().serializeSpecialFloatingPointValues().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getName().equals("dataSize") && f.getDeclaredClass().getName().equals("int") && f.getDeclaringClass().equals(ColumnValue.class);
            }

            public boolean shouldSkipClass(Class<?> aClass) {
                return false;
            }
        }}).enableComplexMapKeySerialization();
        if (prettyFormat) {
            return builder.setPrettyPrinting().create().toJson((Object)this);
        }
        return builder.create().toJson((Object)this);
    }

    public void printRequestInfo() {
        System.out.println(this.getRequestInfo(true));
    }

    private SearchRequest(Builder builder) {
        this.setTableName(builder.tableName);
        this.setIndexName(builder.indexName);
        this.setSearchQuery(builder.searchQuery);
        this.setColumnsToGet(builder.columnsToGet);
        this.setRoutingValues(builder.routingValues);
        this.setTimeoutInMillisecond(builder.timeoutInMillisecond);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String tableName;
        private String indexName;
        private SearchQuery searchQuery;
        private ColumnsToGet columnsToGet;
        private List<PrimaryKey> routingValues;
        private int timeoutInMillisecond = -1;

        private Builder() {
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder searchQuery(SearchQuery searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public Builder addColumnsToGet(String ... columnsToGet) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
            }
            this.columnsToGet.getColumns().addAll(Arrays.asList(columnsToGet));
            return this;
        }

        public Builder addColumnsToGet(List<String> columnsToGetList) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
            }
            this.columnsToGet.getColumns().addAll(columnsToGetList);
            return this;
        }

        public Builder returnAllColumns(boolean returnAll) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
            }
            this.columnsToGet.setReturnAll(returnAll);
            return this;
        }

        public Builder returnAllColumnsFromIndex(boolean returnAllIndex) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
            }
            this.columnsToGet.setReturnAllFromIndex(returnAllIndex);
            return this;
        }

        public Builder addRoutingValue(PrimaryKeyBuilder primaryKeyBuilder) {
            if (this.routingValues == null) {
                this.routingValues = new ArrayList<PrimaryKey>();
            }
            this.routingValues.add(primaryKeyBuilder.build());
            return this;
        }

        public Builder addRoutingValues(List<PrimaryKey> primaryKeys) {
            if (this.routingValues == null) {
                this.routingValues = new ArrayList<PrimaryKey>();
            }
            this.routingValues.addAll(primaryKeys);
            return this;
        }

        public Builder timeout(int timeoutInMillisecond) {
            if (timeoutInMillisecond > 0) {
                this.timeoutInMillisecond = timeoutInMillisecond;
            }
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }

    public static class ColumnsToGet {
        private List<String> columns = new ArrayList<String>();
        private boolean returnAll = false;
        private boolean returnAllFromIndex = false;

        public List<String> getColumns() {
            return this.columns;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public boolean isReturnAll() {
            return this.returnAll;
        }

        public void setReturnAll(boolean returnAll) {
            if (returnAll && this.returnAllFromIndex) {
                throw new IllegalArgumentException("The parameter returnAll and returnAllFromIndex should not all be true.");
            }
            this.returnAll = returnAll;
        }

        public boolean isReturnAllFromIndex() {
            return this.returnAllFromIndex;
        }

        public void setReturnAllFromIndex(boolean returnAllFromIndex) {
            if (this.returnAll && returnAllFromIndex) {
                throw new IllegalArgumentException("The parameter returnAll and returnAllFromIndex should not all be true.");
            }
            this.returnAllFromIndex = returnAllFromIndex;
        }
    }
}

