/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.protocol;

import com.aliyun.ots.thirdparty.org.apache.HttpConnection;
import com.aliyun.ots.thirdparty.org.apache.HttpException;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.HttpInetConnection;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpRequestInterceptor;
import com.aliyun.ots.thirdparty.org.apache.HttpVersion;
import com.aliyun.ots.thirdparty.org.apache.ProtocolException;
import com.aliyun.ots.thirdparty.org.apache.ProtocolVersion;
import com.aliyun.ots.thirdparty.org.apache.annotation.Immutable;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpContext;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpCoreContext;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

