/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.http.ExecutionContext;
import com.alicloud.openservices.tablestore.core.http.HttpFactory;
import com.alicloud.openservices.tablestore.core.http.RequestHandler;
import com.alicloud.openservices.tablestore.core.http.RequestMessage;
import com.alicloud.openservices.tablestore.core.http.ResponseConsumer;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.concurrent.FutureCallback;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.CloseableHttpAsyncClient;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.reactor.DefaultConnectingIOReactor;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.reactor.IOReactorConfig;
import com.aliyun.ots.thirdparty.org.apache.nio.conn.NHttpClientConnectionManager;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.BasicAsyncRequestProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.IOReactorException;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AsyncServiceClient {
    private CloseableHttpAsyncClient httpClient;
    private IdleConnectionEvictor connEvictor;
    private Map<String, String> extraHeaders;

    public AsyncServiceClient(ClientConfiguration config) {
        try {
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoThreadCount()).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager(ioReactor);
            cm.setMaxTotal(config.getMaxConnections());
            cm.setDefaultMaxPerRoute(config.getMaxConnections());
            this.httpClient = HttpFactory.createHttpAsyncClient(config, cm);
            long closePeriod = 5000L;
            if (config.getSocketTimeoutInMillisecond() > 0) {
                closePeriod = (long)((double)config.getSocketTimeoutInMillisecond() / 2.5);
            }
            closePeriod = closePeriod < 5000L ? closePeriod : 5000L;
            this.connEvictor = new IdleConnectionEvictor(cm, closePeriod);
            this.httpClient.start();
            this.connEvictor.start();
        }
        catch (IOReactorException ex) {
            throw new ClientException(String.format("IOReactorError: %s", ex.getMessage()), ex);
        }
    }

    public Map<String, String> getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public <Res> void asyncSendRequest(RequestMessage request, ExecutionContext context, ResponseConsumer<Res> consumer, FutureCallback<Res> callback, TraceLogger traceLogger) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(context);
        this.addExtraHeaders(request);
        context.getSigner().sign(request);
        this.handleRequest(request, context.getResquestHandlers());
        consumer.setContext(context);
        HttpHost target = request.getActionUri().getHost();
        if (LogUtil.LOG.isDebugEnabled()) {
            LogUtil.LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "IntoHttpAsyncClient");
        }
        traceLogger.addEventTime("IntoHttpAsyncClient", System.currentTimeMillis());
        this.httpClient.execute(new OTSRequestProducer(target, request.getRequest(), traceLogger), consumer, callback);
    }

    private void addExtraHeaders(RequestMessage request) {
        if (this.extraHeaders == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.extraHeaders.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private void handleRequest(RequestMessage message, List<RequestHandler> requestHandlers) throws ClientException {
        for (RequestHandler h2 : requestHandlers) {
            h2.handle(message);
        }
    }

    public void shutdown() {
        try {
            this.connEvictor.shutdown();
            this.connEvictor.join();
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new ClientException("Failed to shutdown http client.", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class OTSRequestProducer
    extends BasicAsyncRequestProducer {
        private TraceLogger traceLogger;

        public OTSRequestProducer(HttpHost target, HttpRequest request, TraceLogger traceLogger) {
            super(target, request);
            this.traceLogger = traceLogger;
        }

        @Override
        public void requestCompleted(HttpContext context) {
            super.requestCompleted(context);
            if (LogUtil.LOG.isDebugEnabled()) {
                LogUtil.LOG.debug("TraceId:" + this.traceLogger.getTraceId() + "\t" + "RequestSent");
            }
            this.traceLogger.addEventTime("RequestSent", System.currentTimeMillis());
        }
    }

    static class IdleConnectionEvictor
    extends Thread {
        private final NHttpClientConnectionManager connMgr;
        private volatile boolean shutdown;
        private long closePeriod;

        public IdleConnectionEvictor(NHttpClientConnectionManager connMgr, long closePeriod) {
            this.connMgr = connMgr;
            this.closePeriod = closePeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionEvictor idleConnectionEvictor = this;
                    synchronized (idleConnectionEvictor) {
                        this.wait(this.closePeriod);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(this.closePeriod, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionEvictor idleConnectionEvictor = this;
            synchronized (idleConnectionEvictor) {
                this.notifyAll();
            }
        }
    }
}

