/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.jdbc.OTSResultSetMetaData;
import com.alicloud.openservices.tablestore.jdbc.OTSStatement;
import com.alicloud.openservices.tablestore.jdbc.WrapperAdapter;
import com.alicloud.openservices.tablestore.model.sql.SQLResultSet;
import com.alicloud.openservices.tablestore.model.sql.SQLRow;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class OTSResultSet
extends WrapperAdapter
implements ResultSet {
    private final OTSResultSetMetaData meta;
    private final Map<String, Integer> nameIndexMap;
    private List<Object[]> rows;
    private OTSStatement stmt;
    private int fetchSize;
    private boolean wasNull = false;
    private int rowIndex = 0;
    private SQLWarning warnings = null;
    private boolean isClosed = false;

    OTSResultSet(OTSStatement stmt, SQLResultSet resultSet, int maxRows) throws SQLException {
        this.stmt = stmt;
        this.meta = new OTSResultSetMetaData(resultSet.getSQLTableMeta());
        this.nameIndexMap = new HashMap<String, Integer>();
        for (Map.Entry column : resultSet.getSQLTableMeta().getColumnsMap().entrySet()) {
            this.nameIndexMap.put((String)column.getKey(), (Integer)column.getValue() + 1);
        }
        this.rows = new ArrayList<Object[]>();
        while (resultSet.hasNext()) {
            SQLRow row = resultSet.next();
            Object[] objects = new Object[this.meta.getColumnCount()];
            for (int i = 0; i < this.meta.getColumnCount(); ++i) {
                objects[i] = row.get(i);
            }
            this.rows.add(objects);
        }
        if (maxRows > 0 && this.rows.size() > maxRows) {
            this.rows = this.rows.subList(0, maxRows);
        }
    }

    OTSResultSet(OTSResultSetMetaData meta, List<Object[]> rows) throws SQLException {
        this.meta = meta;
        this.rows = rows;
        this.nameIndexMap = new HashMap<String, Integer>();
        for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
            this.nameIndexMap.put(this.meta.getColumnName(i), i);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) {
        this.fetchSize = rows;
    }

    @Override
    public boolean absolute(int row) {
        this.rowIndex = row < 0 ? this.rows.size() + 1 + row : row;
        return 0 < this.rowIndex && this.rowIndex <= this.rows.size();
    }

    @Override
    public void afterLast() {
        this.rowIndex = this.rows.size() + 1;
    }

    @Override
    public void beforeFirst() {
        this.rowIndex = 0;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean first() {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.rowIndex = 1;
        return true;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof Long) {
            return new BigDecimal(this.getLong(columnIndex));
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf(this.getDouble(columnIndex));
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof ByteBuffer) {
            return new BigDecimal(new String(this.unwrapByteBuffer((ByteBuffer)value)));
        }
        throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), BigDecimal.class.getName()));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (!this.nameIndexMap.containsKey(columnLabel)) {
            throw new SQLException(String.format("Column '%s' not found.", columnLabel));
        }
        return this.nameIndexMap.get(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.rowIndex < 1) {
            throw new SQLException("Before start of result set");
        }
        if (this.rowIndex > this.rows.size()) {
            throw new SQLException("After end of result set");
        }
        if (columnIndex < 1) {
            throw new SQLException(String.format("Column Index out of range, %d < 1.", columnIndex));
        }
        if (columnIndex > this.meta.getColumnCount()) {
            throw new SQLException(String.format("Column Index out of range, %d > %d.", columnIndex, this.meta.getColumnCount()));
        }
        Object value = this.rows.get(this.rowIndex - 1)[columnIndex - 1];
        this.wasNull = value == null;
        return value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof String)) {
            throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), InputStream.class.getName()));
        }
        return new ByteArrayInputStream(this.getBytes(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof String)) {
            throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), Blob.class.getName()));
        }
        return new SerialBlob(this.getBytes(columnIndex));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBlob(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Long) {
            return (Long)value != 0L;
        }
        if (value instanceof Double) {
            return (Double)value != 0.0;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof ByteBuffer) {
            return Boolean.parseBoolean(new String(this.unwrapByteBuffer((ByteBuffer)value)));
        }
        throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), Boolean.class.getName()));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        long value = this.getLong(columnIndex);
        if (value < -128L || value > 127L) {
            throw new SQLException(String.format("Value '%s' is outside of valid range for type %s", this.getString(columnIndex), Byte.class.getName()));
        }
        return (byte)value;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getByte(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof ByteBuffer) {
            return this.unwrapByteBuffer((ByteBuffer)value);
        }
        if (value instanceof Long || value instanceof Double || value instanceof Boolean || value instanceof String) {
            return value.toString().getBytes();
        }
        throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), byte[].class.getName()));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBytes(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof String)) {
            throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), Reader.class.getName()));
        }
        return new CharArrayReader(this.getString(columnIndex).toCharArray());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof String)) {
            throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), Clob.class.getName()));
        }
        return new SerialClob(this.getString(columnIndex).toCharArray());
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getClob(columnIndex);
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof ByteBuffer) {
            return Double.parseDouble(new String(this.unwrapByteBuffer((ByteBuffer)value)));
        }
        throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), Double.class.getName()));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        double value = this.getDouble(columnIndex);
        if (Math.abs(value) > 3.4028234663852886E38) {
            throw new SQLException(String.format("Value '%s' is outside of valid range for type %s", this.getString(columnIndex), Float.class.getName()));
        }
        return (float)value;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        long value = this.getLong(columnIndex);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new SQLException(String.format("Value '%s' is outside of valid range for type %s", this.getString(columnIndex), Integer.class.getName()));
        }
        return (int)value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof ByteBuffer) {
            return Long.parseLong(new String(this.unwrapByteBuffer((ByteBuffer)value)));
        }
        throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), Long.class.getName()));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public OTSResultSetMetaData getMetaData() {
        return this.meta;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ByteBuffer) {
            return new String(this.unwrapByteBuffer((ByteBuffer)value));
        }
        if (value instanceof Long || value instanceof Double || value instanceof Boolean) {
            return value.toString();
        }
        throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), String.class.getName()));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getString(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getRow() {
        return this.rowIndex;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        long value = this.getLong(columnIndex);
        if (value < -32768L || value > 32767L) {
            throw new SQLException(String.format("Value '%s' is outside of valid range for type %s", this.getString(columnIndex), Short.class.getName()));
        }
        return (short)value;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public OTSStatement getStatement() throws SQLException {
        this.checkClosed();
        return this.stmt;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (!(value instanceof ByteBuffer) && !(value instanceof String)) {
            throw new SQLException(String.format("Unsupported conversion from %s to %s", this.meta.getColumnTypeName(columnIndex), URL.class.getName()));
        }
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getURL(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isFirst() {
        return this.rowIndex == 1;
    }

    @Override
    public boolean isLast() {
        return this.rowIndex == this.rows.size();
    }

    @Override
    public boolean last() {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.rowIndex = this.rows.size();
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.rowIndex < this.rows.size()) {
            ++this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the result set has already been closed");
        }
    }

    private byte[] unwrapByteBuffer(ByteBuffer buffer) {
        ByteBuffer copy = buffer.duplicate();
        byte[] bytes = new byte[copy.remaining()];
        copy.get(bytes);
        return bytes;
    }
}

