/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.jdbc.OTSConnection;
import com.alicloud.openservices.tablestore.jdbc.OTSStatement;
import com.alicloud.openservices.tablestore.jdbc.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class OTSPreparedStatement
extends OTSStatement
implements PreparedStatement {
    private final String sql;
    private final List<Integer> placeholders;
    private final HashMap<Integer, Object> parameters;

    OTSPreparedStatement(OTSConnection conn, String sql) throws SQLException {
        super(conn);
        this.sql = sql;
        this.placeholders = OTSPreparedStatement.findPlaceholders(sql);
        this.parameters = new HashMap();
    }

    static List<Integer> findPlaceholders(String sql) throws SQLException {
        if (sql == null) {
            throw new SQLException("SQL String cannot be NULL");
        }
        ArrayList<Integer> placeholders = new ArrayList<Integer>();
        char quoted = '\u0000';
        block5: for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\\': {
                    ++i;
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    if (c == quoted) {
                        quoted = '\u0000';
                        continue block5;
                    }
                    quoted = c;
                    continue block5;
                }
                case '?': {
                    if (quoted != '\u0000') continue block5;
                    placeholders.add(i);
                }
            }
        }
        return placeholders;
    }

    String interpolateParameters() throws SQLException {
        StringBuilder builder = new StringBuilder();
        int beginIndex = 0;
        for (int i = 0; i < this.placeholders.size(); ++i) {
            int placeholder = this.placeholders.get(i);
            builder.append(this.sql, beginIndex, placeholder);
            Object value = this.parameters.get(i);
            builder.append(this.toSqlString(value));
            beginIndex = placeholder + 1;
        }
        builder.append(this.sql.substring(beginIndex));
        return builder.toString();
    }

    private String toSqlString(Object x) throws SQLException {
        if (x == null) {
            return "NULL";
        }
        if (x instanceof Boolean || x instanceof Byte || x instanceof Short || x instanceof Integer || x instanceof Long || x instanceof Float || x instanceof Double) {
            return x.toString();
        }
        if (x instanceof BigDecimal) {
            return ((BigDecimal)x).toPlainString();
        }
        if (x instanceof String) {
            return StringUtils.quoteIdentifier(x.toString(), "'", true);
        }
        if (x instanceof byte[]) {
            return String.format("x'%s'", Hex.encodeHexString((byte[])((byte[])x)));
        }
        throw new SQLException("unrecognized Java class: " + x.getClass().getName());
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        this.parameters.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.interpolateParameters());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.interpolateParameters());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.interpolateParameters());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return super.getResultSet().getMetaData();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else {
            try {
                this.setBytes(parameterIndex, IOUtils.toByteArray((InputStream)x));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else {
            try {
                this.setBytes(parameterIndex, IOUtils.toByteArray((InputStream)x, (long)length));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else {
            this.setBinaryStream(parameterIndex, x.getBinaryStream());
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 0);
        } else {
            try {
                this.setString(parameterIndex, IOUtils.toString((Reader)reader));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 0);
        } else {
            char[] buf = new char[length];
            try {
                int readLength = reader.read(buf);
                buf = readLength != -1 ? Arrays.copyOfRange(buf, 0, readLength) : new char[]{};
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            this.setString(parameterIndex, new String(buf));
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else {
            this.setCharacterStream(parameterIndex, x.getCharacterStream());
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (value == null) {
            this.setNull(parameterIndex, 0);
        } else {
            this.setCharacterStream(parameterIndex, value.getCharacterStream());
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.placeholders.size()) {
            throw new SQLException("parameter index out of range");
        }
        if (x == null || x instanceof Boolean || x instanceof String || x instanceof Byte || x instanceof Short || x instanceof Integer || x instanceof Float || x instanceof Double || x instanceof Long || x instanceof BigDecimal || x instanceof byte[]) {
            this.parameters.put(parameterIndex - 1, x);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof URL) {
            this.setURL(parameterIndex, (URL)x);
        } else {
            throw new SQLException("unsupported type: " + x.getClass().getName());
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setLong(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setDouble(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setLong(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setLong(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setString(parameterIndex, x.toString());
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, length);
    }
}

