/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.jdbc.OTSConnection;
import com.alicloud.openservices.tablestore.jdbc.OTSConnectionConfiguration;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class OTSDriver
implements Driver {
    static final String OTS_JDBC_URL_PREFIX = "jdbc:ots:";
    static final boolean OTS_JDBC_COMPLIANT = false;
    static final int OTS_JDBC_MAJOR_VERSION = 4;
    static final int OTS_JDBC_MINOR_VERSION = 2;
    static final int OTS_DRIVER_MAJOR_VERSION = 5;
    static final int OTS_DRIVER_MINOR_VERSION = 13;
    static final String OTS_DRIVER_VERSION = "5.13.9";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? new OTSConnection(url, info) : null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(OTS_JDBC_URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ClientConfiguration configuration = OTSConnectionConfiguration.parse(url, info).getClientConfiguration();
        return new DriverPropertyInfo[]{new DriverPropertyInfo("enableRequestCompression", String.valueOf(configuration.isEnableRequestCompression())), new DriverPropertyInfo("enableResponseCompression", String.valueOf(configuration.isEnableResponseCompression())), new DriverPropertyInfo("enableResponseValidation", String.valueOf(configuration.isEnableResponseValidation())), new DriverPropertyInfo("ioThreadCount", String.valueOf(configuration.getIoThreadCount())), new DriverPropertyInfo("maxConnections", String.valueOf(configuration.getMaxConnections())), new DriverPropertyInfo("socketTimeoutInMillisecond", String.valueOf(configuration.getSocketTimeoutInMillisecond())), new DriverPropertyInfo("connectionTimeoutInMillisecond", String.valueOf(configuration.getConnectionTimeoutInMillisecond())), new DriverPropertyInfo("retryThreadCount", String.valueOf(configuration.getRetryThreadCount())), new DriverPropertyInfo("enableResponseContentMD5Checking", String.valueOf(configuration.isEnableResponseContentMD5Checking())), new DriverPropertyInfo("timeThresholdOfServerTracer", String.valueOf(configuration.getTimeThresholdOfServerTracer())), new DriverPropertyInfo("timeThresholdOfTraceLogger", String.valueOf(configuration.getTimeThresholdOfTraceLogger())), new DriverPropertyInfo("proxyHost", configuration.getProxyHost()), new DriverPropertyInfo("proxyPort", String.valueOf(configuration.getProxyPort())), new DriverPropertyInfo("proxyUsername", configuration.getProxyUsername()), new DriverPropertyInfo("proxyPassword", configuration.getProxyPassword()), new DriverPropertyInfo("proxyDomain", configuration.getProxyDomain()), new DriverPropertyInfo("proxyWorkstation", configuration.getProxyWorkstation()), new DriverPropertyInfo("syncClientWaitFutureTimeoutInMillis", String.valueOf(configuration.getSyncClientWaitFutureTimeoutInMillis())), new DriverPropertyInfo("connectionRequestTimeoutInMillisecond", String.valueOf(configuration.getConnectionRequestTimeoutInMillisecond()))};
    }

    @Override
    public int getMajorVersion() {
        return 5;
    }

    @Override
    public int getMinorVersion() {
        return 13;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new OTSDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

