/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.jdbc;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.jdbc.OTSConnectionConfiguration;
import com.alicloud.openservices.tablestore.jdbc.OTSDatabaseMetaData;
import com.alicloud.openservices.tablestore.jdbc.OTSPreparedStatement;
import com.alicloud.openservices.tablestore.jdbc.OTSStatement;
import com.alicloud.openservices.tablestore.jdbc.WrapperAdapter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class OTSConnection
extends WrapperAdapter
implements Connection {
    static final String ACCESS_KEY_ID = "user";
    static final String ACCESS_KEY_SECRET = "password";
    static final String ENABLE_REQUEST_COMPRESSION = "enableRequestCompression";
    static final String ENABLE_RESPONSE_COMPRESSION = "enableResponseCompression";
    static final String ENABLE_RESPONSE_VALIDATION = "enableResponseValidation";
    static final String IO_THREAD_COUNT = "ioThreadCount";
    static final String MAX_CONNECTIONS = "maxConnections";
    static final String SOCKET_TIMEOUT_IN_MILLISECOND = "socketTimeoutInMillisecond";
    static final String CONNECTION_TIMEOUT_IN_MILLISECOND = "connectionTimeoutInMillisecond";
    static final String RETRY_THREAD_COUNT = "retryThreadCount";
    static final String ENABLE_RESPONSE_CONTENT_MD5_CHECKING = "enableResponseContentMD5Checking";
    static final String RETRY_STRATEGY = "retryStrategy";
    static final String TIME_THRESHOLD_OF_TRACE_LOGGER = "timeThresholdOfTraceLogger";
    static final String TIME_THRESHOLD_OF_SERVER_TRACER = "timeThresholdOfServerTracer";
    static final String PROXY_HOST = "proxyHost";
    static final String PROXY_PORT = "proxyPort";
    static final String PROXY_USERNAME = "proxyUsername";
    static final String PROXY_PASSWORD = "proxyPassword";
    static final String PROXY_DOMAIN = "proxyDomain";
    static final String PROXY_WORKSTATION = "proxyWorkstation";
    static final String SYNC_CLIENT_WAIT_FUTURE_TIMEOUT_IN_MILLIS = "syncClientWaitFutureTimeoutInMillis";
    static final String CONNECTION_REQUEST_TIMEOUT_IN_MILLISECOND = "connectionRequestTimeoutInMillisecond";
    private final String url;
    OTSConnectionConfiguration config;
    SyncClient otsClient;
    private Properties info;
    private boolean isClosed = false;
    private SQLWarning warnings = null;

    OTSConnection(String url, Properties info) throws SQLException {
        this.url = url;
        this.info = info;
        this.config = OTSConnectionConfiguration.parse(url, info);
        this.otsClient = new SyncClient(this.config.getEndPoint(), this.config.getAccessKeyId(), this.config.getAccessKeySecret(), this.config.getInstanceName());
    }

    @Override
    public OTSPreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new OTSPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public OTSPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("disabling autocommit is not supported");
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.otsClient.shutdown();
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new OTSDatabaseMetaData(this);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (readOnly) {
            throw new SQLFeatureNotSupportedException("enabling read-only is not supported");
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.config.getInstanceName();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.config.setInstanceName(catalog);
        this.reconnect();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OTSStatement createStatement() throws SQLException {
        this.checkClosed();
        return new OTSStatement(this);
    }

    @Override
    public OTSStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        return new SerialClob(new char[0]);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new SerialBlob(new byte[0]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
            this.info.setProperty(name, value);
            this.reconnect();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this.info;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
            this.info = properties;
            this.reconnect();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.info.getProperty(name);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        this.info.setProperty(CONNECTION_REQUEST_TIMEOUT_IN_MILLISECOND, String.valueOf(milliseconds));
        this.reconnect();
    }

    @Override
    public int getNetworkTimeout() {
        return this.config.getClientConfiguration().getConnectionRequestTimeoutInMillisecond();
    }

    private void reconnect() throws SQLException {
        this.otsClient.shutdown();
        this.config = OTSConnectionConfiguration.parse(this.url, this.info);
        this.otsClient = new SyncClient(this.config.getEndPoint(), this.config.getAccessKeyId(), this.config.getAccessKeySecret(), this.config.getInstanceName());
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the connection has already been closed");
        }
    }
}

