package com.aliyun.openservices.iot.api.message.entity;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;

/**
 * Message entity
 *
 * @author brhao
 * @date 19/03/2018
 */
@Data
public class Message {
    private static final int QOS0 = 0;
    private static final int QOS1 = 1;
    private static final int QOS2 = 2;

    /**
     * payload
     */
    private byte[] payload;

    /**
     * messageId
     */
    private String messageId;

    /**
     * topic
     */
    @Setter(AccessLevel.NONE)
    private String topic;

    /**
     * qos
     */
    @Setter(AccessLevel.NONE)
    private int qos;

    /**
     * 消息产生时间，单位为ms
     */
    @Setter(AccessLevel.NONE)
    private long generateTime;

    public void setQos(int qos) {
        if ((qos < QOS0) || (qos > QOS2)) {
            throw new IllegalArgumentException();
        }
        this.qos = qos;
    }

    public Message(byte[] payload) {
        this.payload = payload;
    }

    public Message(byte[] payload, int qos) {
        this.payload = payload;
        this.qos = qos;
    }

    public Message(byte[] payload, String topic, String messageId, int qos, long generateTime) {
        this.payload = payload;
        this.topic = topic;
        this.messageId = messageId;
        this.qos = qos;
        this.generateTime = generateTime;
    }

    public Message() {
    }

    @Override
    public String toString() {
        return "Message{" +
                "payload=" + new String(payload) +
                ", topic='" + topic + '\'' +
                ", messageId='" + messageId + '\'' +
                ", qos=" + qos +
                ", generateTime=" + generateTime +
                '}';
    }
}
