package com.aliyun.openservices.iot.api.message.callback;

import com.aliyun.openservices.iot.api.message.entity.MessageToken;

/**
 * Message listener
 * registers the message listener to receive message.
 * <strong>Thread safety: </strong>
 * The interface will be called concurrently by multiple threads.
 * The user needs to ensure concurrent security.
 *
 * @author brhao
 */
public interface MessageCallback {
    enum Action {
        /**
         * Message is consumed successfully.
         * For message which qos &gt; 0, client will reply ack
         */
        CommitSuccess,

        /**
         * Fail to consume message .
         * for message which qos &gt; 0, client won't reply ack and server will redelivery it later
         */
        CommitFailure,

        /**
         * Consume message successfully and reply ack manually
         * for message which qos &gt; 0, client won't reply ack, you should call MessageClient.ack() to reply ack.
         */
        CommitAckManually
    }

    /**
     * message callback method, implemented by the user
     *
     * @param messageToken message token
     * @return Action after consuming
     */
    Action consume(final MessageToken messageToken);
}
