package com.aliyun.openservices.iot.api.message.api;

import com.aliyun.openservices.iot.api.message.callback.ConnectionCallback;
import com.aliyun.openservices.iot.api.message.callback.MessageCallback;
import com.aliyun.openservices.iot.api.message.entity.Message;
import com.aliyun.openservices.iot.api.message.entity.MessageToken;

import java.util.concurrent.CompletableFuture;

/**
 * @author brhao
 * @date 08/05/2018
 */
public interface MessageClient {
    /**
     * connect to iothub
     *
     * @param messageCallback callback when message received
     */
    void connect(MessageCallback messageCallback);

    /**
     * disconnect
     */
    void disconnect();

    /**
     * set listener for topic
     *
     * @param messageCallback callback when message received
     */
    void setMessageListener(MessageCallback messageCallback);

    /**
     * set listener for topic
     *
     * @param topic           topic
     * @param messageCallback callback when message received and topic matched
     */
    void setMessageListener(String topic, MessageCallback messageCallback);

    /**
     * subscribe
     *
     * @param topic topic
     * @return completableFuture for subscribe result
     */
    CompletableFuture<Boolean> subscribe(String topic);

    /**
     * subscribe
     *
     * @param topic           topic
     * @param messageCallback callback when message received on this topic
     * @return completableFuture for subscribe result
     */
    CompletableFuture<Boolean> subscribe(String topic, MessageCallback messageCallback);

    /**
     * unsubscribe
     *
     * @param topic topic
     * @return completableFuture for unsubscribe result
     */
    CompletableFuture<Boolean> unsubscribe(String topic);

    /**
     * publish message to topic
     *
     * @param topic   topic
     * @param message message entity
     * @return completableFuture for publish result
     */
    MessageToken publish(String topic, Message message);

    /**
     * ack message
     *
     * @param messageToken token for message
     * @return completableFuture for ack result
     */
    CompletableFuture<Boolean> ack(MessageToken messageToken);

    /**
     * is client connected
     *
     * @return isConnected
     */
    boolean isConnected();

    /**
     * set callback for connection
     * @param connectionCallback callback
     */
    void setConnectionCallback(ConnectionCallback connectionCallback);
}
