/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.netty;

import com.aliyun.openservices.iot.api.http2.netty.NettyHttp2HandlerBuilder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttp2Initializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttp2Initializer.class);
    private static final String TLS_PROTOCOL_VERSION_1_2 = "TLSv1.2";
    private NettyHttp2HandlerBuilder handlerBuilder;
    private boolean enableSsl = false;
    private SSLContext sslContext;

    public NettyHttp2Initializer(NettyHttp2HandlerBuilder handlerBuilder, boolean enableSsl) throws NoSuchAlgorithmException, KeyManagementException {
        this.handlerBuilder = handlerBuilder;
        this.enableSsl = enableSsl;
    }

    protected void initChannel(SocketChannel ch) throws NoSuchAlgorithmException, KeyManagementException, IOException, KeyStoreException, CertificateException {
        log.info("init http2 handler. enable SSL : {}", (Object)this.enableSsl);
        if (this.enableSsl) {
            if (this.sslContext == null) {
                Certificate ca;
                this.sslContext = SSLContext.getInstance(TLS_PROTOCOL_VERSION_1_2);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/root.crt");){
                    ca = cf.generateCertificate(in);
                }
                String keyStoreType = KeyStore.getDefaultType();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(null, null);
                keyStore.setCertificateEntry("ca", ca);
                String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                tmf.init(keyStore);
                this.sslContext.init(null, InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            }
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
        }
        ch.pipeline().addLast(new ChannelHandler[]{this.handlerBuilder.build()});
    }
}

