/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.auth.handler;

import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class DeviceAuthHandler
implements AuthHandler {
    private static final String PARAM_SIGN = "param-sign";
    private static final String PARAM_SIGNMETHOD = "param-signmethod";
    private static final String HMACMD5 = "hmacmd5";
    private static final String PARAM_TIMESTAMP = "param-timestamp";
    private Map<String, String> params = Maps.newHashMap();

    public DeviceAuthHandler(Map<String, String> authParams) {
        this.params.putAll(authParams);
        String now = String.valueOf(System.currentTimeMillis());
        String productKey = authParams.get("param-product-key");
        String deviceName = authParams.get("param-device-name");
        String clientId = authParams.get("param-client-id");
        String deviceSecret = authParams.get("deviceSecret");
        String signOrigin = "clientId" + clientId + "deviceName" + deviceName + "productKey" + productKey + "timestamp" + now;
        this.params.put(PARAM_TIMESTAMP, now);
        this.params.put(PARAM_SIGNMETHOD, HMACMD5);
        String sign = new HmacUtils(HmacAlgorithms.HMAC_MD5, deviceSecret).hmacHex(signOrigin);
        this.params.put(PARAM_SIGN, sign);
        this.params.remove("deviceSecret");
    }

    @Override
    public Map<String, String> getAuthParams() {
        return this.params;
    }
}

