/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profile {
    private static final Logger log = LoggerFactory.getLogger(Profile.class);
    public static final boolean ENABLE_SSL = true;
    public static final int DEFAULT_PORT = 443;
    private String endPoint;
    private String host;
    private int port;
    private boolean cleanSession;
    private int heartBeatInterval = 30000;
    private int heartBeatTimeOut = 60000;
    private boolean multiConnection = false;
    private int callbackThreadCorePoolSize = Runtime.getRuntime().availableProcessors();
    private int callbackThreadMaximumPoolSize = Runtime.getRuntime().availableProcessors() * 4;
    private int callbackThreadBlockingQueueSize = 1024;
    private Map<String, String> authParams;

    public String getHost() {
        return this.url().map(URL::getHost).orElse(null);
    }

    public int getPort() {
        return this.url().map(URL::getPort).filter(p -> p != -1).orElse(443);
    }

    private Optional<URL> url() {
        try {
            URL url = new URL(this.endPoint);
            return Optional.of(url);
        }
        catch (MalformedURLException e) {
            log.error("fail to parse url {},{}", (Object)this.endPoint, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private Profile(String endPoint) {
        this.endPoint = endPoint;
        this.authParams = Maps.newHashMap();
    }

    public static Profile getDeviceProfile(String endPoint, String productKey, String deviceName, String deviceSecret, String clientId) {
        Profile profile = new Profile(endPoint);
        profile.authParams.put("name", "devicename");
        profile.authParams.put("param-product-key", productKey);
        profile.authParams.put("param-device-name", deviceName);
        profile.authParams.put("deviceSecret", deviceSecret);
        profile.authParams.put("param-client-id", clientId);
        profile.multiConnection = false;
        return profile;
    }

    public static Profile getAppKeyProfile(String endPoint, String appKey, String appSecret) {
        Profile profile = new Profile(endPoint);
        profile.authParams.put("name", "appkey");
        profile.authParams.put("param-app-key", appKey);
        profile.authParams.put("appSecret", appSecret);
        profile.multiConnection = true;
        return profile;
    }

    public static Profile getAccessKeyProfile(String endPoint, String regionId, String accessKey, String accessSecret) {
        return Profile.getAccessKeyProfile(endPoint, regionId, accessKey, accessSecret, null);
    }

    public static Profile getAccessKeyProfile(String endPoint, String regionId, String accessKey, String accessSecret, String stsToken) {
        Profile profile = new Profile(endPoint);
        profile.authParams.put("name", "aliyunak");
        profile.authParams.put("accessKey", accessKey);
        profile.authParams.put("accessSecret", accessSecret);
        profile.authParams.put("regionId", regionId);
        profile.authParams.put("stsToken", stsToken);
        profile.multiConnection = true;
        return profile;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public int getHeartBeatTimeOut() {
        return this.heartBeatTimeOut;
    }

    public boolean isMultiConnection() {
        return this.multiConnection;
    }

    public int getCallbackThreadCorePoolSize() {
        return this.callbackThreadCorePoolSize;
    }

    public int getCallbackThreadMaximumPoolSize() {
        return this.callbackThreadMaximumPoolSize;
    }

    public int getCallbackThreadBlockingQueueSize() {
        return this.callbackThreadBlockingQueueSize;
    }

    public Map<String, String> getAuthParams() {
        return this.authParams;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public void setHeartBeatInterval(int heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public void setHeartBeatTimeOut(int heartBeatTimeOut) {
        this.heartBeatTimeOut = heartBeatTimeOut;
    }

    public void setMultiConnection(boolean multiConnection) {
        this.multiConnection = multiConnection;
    }

    public void setCallbackThreadCorePoolSize(int callbackThreadCorePoolSize) {
        this.callbackThreadCorePoolSize = callbackThreadCorePoolSize;
    }

    public void setCallbackThreadMaximumPoolSize(int callbackThreadMaximumPoolSize) {
        this.callbackThreadMaximumPoolSize = callbackThreadMaximumPoolSize;
    }

    public void setCallbackThreadBlockingQueueSize(int callbackThreadBlockingQueueSize) {
        this.callbackThreadBlockingQueueSize = callbackThreadBlockingQueueSize;
    }

    public void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isCleanSession() != other.isCleanSession()) {
            return false;
        }
        if (this.getHeartBeatInterval() != other.getHeartBeatInterval()) {
            return false;
        }
        if (this.getHeartBeatTimeOut() != other.getHeartBeatTimeOut()) {
            return false;
        }
        if (this.isMultiConnection() != other.isMultiConnection()) {
            return false;
        }
        if (this.getCallbackThreadCorePoolSize() != other.getCallbackThreadCorePoolSize()) {
            return false;
        }
        if (this.getCallbackThreadMaximumPoolSize() != other.getCallbackThreadMaximumPoolSize()) {
            return false;
        }
        if (this.getCallbackThreadBlockingQueueSize() != other.getCallbackThreadBlockingQueueSize()) {
            return false;
        }
        Map<String, String> this$authParams = this.getAuthParams();
        Map<String, String> other$authParams = other.getAuthParams();
        return !(this$authParams == null ? other$authParams != null : !((Object)this$authParams).equals(other$authParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Profile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isCleanSession() ? 79 : 97);
        result = result * 59 + this.getHeartBeatInterval();
        result = result * 59 + this.getHeartBeatTimeOut();
        result = result * 59 + (this.isMultiConnection() ? 79 : 97);
        result = result * 59 + this.getCallbackThreadCorePoolSize();
        result = result * 59 + this.getCallbackThreadMaximumPoolSize();
        result = result * 59 + this.getCallbackThreadBlockingQueueSize();
        Map<String, String> $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : ((Object)$authParams).hashCode());
        return result;
    }

    public String toString() {
        return "Profile(endPoint=" + this.getEndPoint() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", cleanSession=" + this.isCleanSession() + ", heartBeatInterval=" + this.getHeartBeatInterval() + ", heartBeatTimeOut=" + this.getHeartBeatTimeOut() + ", multiConnection=" + this.isMultiConnection() + ", callbackThreadCorePoolSize=" + this.getCallbackThreadCorePoolSize() + ", callbackThreadMaximumPoolSize=" + this.getCallbackThreadMaximumPoolSize() + ", callbackThreadBlockingQueueSize=" + this.getCallbackThreadBlockingQueueSize() + ", authParams=" + this.getAuthParams() + ")";
    }
}

