/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.impl;

import com.aliyun.odps.udf.OdpsType;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.annotation.PreferWritable;
import com.aliyun.odps.udf.annotation.Resolve;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AnnotationParser {
    private static Set<String> registeredTypes = new HashSet<String>();

    public static ParseResult parse(Class<?> clz) throws ParseError {
        String[] infos;
        ParseResult result = new ParseResult();
        Resolve r = clz.getAnnotation(Resolve.class);
        if (r == null) {
            throw new ParseError("@Resolve annotation not found.");
        }
        for (String info : infos = r.value()) {
            String errMsg = "@Resolve({\"" + info + "\"}) ";
            if (info.isEmpty()) {
                throw new ParseError(errMsg + "must not be empty string");
            }
            int pos = info.indexOf("->");
            String args = "";
            if (pos > 0) {
                args = info.substring(0, pos);
            } else if (pos < 0) {
                throw new ParseError(errMsg);
            }
            int tPos = info.indexOf("->", pos + 2);
            if (tPos >= 0) {
                throw new ParseError(errMsg + "contains not exactly one '->'");
            }
            String rtypes = info.substring(pos + 2, info.length());
            Prototype proto = new Prototype();
            String[] tokens = AnnotationParser.getTypeInfos(args);
            if (tokens == null) {
                throw new ParseError(errMsg + "annotates wrong arguments '" + args + "'");
            }
            proto.setArguments(AnnotationParser.createTypes(tokens));
            if (rtypes.isEmpty()) {
                throw new ParseError(errMsg + "annotates no output types '" + args + "'");
            }
            tokens = AnnotationParser.getTypeInfos(rtypes);
            if (tokens == null) {
                throw new ParseError(errMsg + "annotates wrong output types '" + rtypes + "'");
            }
            proto.setReturns(AnnotationParser.createTypes(tokens));
            result.getProtoTypes().add(proto);
        }
        PreferWritable wr = clz.getAnnotation(PreferWritable.class);
        result.setWritable(wr != null);
        return result;
    }

    private static String[] getTypeInfos(String sig) {
        String[] sigArray;
        if (sig.isEmpty()) {
            return new String[0];
        }
        for (String type : sigArray = StringUtils.splitPreserveAllTokens((String)sig.toUpperCase(), (char)',')) {
            if (registeredTypes.contains(type)) continue;
            return null;
        }
        return sigArray;
    }

    private static OdpsType[] createTypes(String[] tokens) {
        OdpsType[] r = new OdpsType[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            r[i] = OdpsType.valueOf(tokens[i].toUpperCase());
        }
        return r;
    }

    static {
        registeredTypes.add(OdpsType.BIGINT.name());
        registeredTypes.add(OdpsType.STRING.name());
        registeredTypes.add(OdpsType.DOUBLE.name());
        registeredTypes.add(OdpsType.BOOLEAN.name());
        registeredTypes.add(OdpsType.DECIMAL.name());
        registeredTypes.add(OdpsType.DATETIME.name());
    }

    public static class ParseResult {
        private boolean writable = false;
        private boolean variadic = false;
        private List<Prototype> prototypes = new ArrayList<Prototype>();

        public boolean isVariadic() {
            return this.variadic;
        }

        public void setVariadic(boolean isVariadic) {
            this.variadic = isVariadic;
        }

        public List<Prototype> getProtoTypes() {
            return this.prototypes;
        }

        public void setTp(List<Prototype> tp) {
            this.prototypes = tp;
        }

        public boolean isWriable() {
            return this.writable;
        }

        public void setWritable(boolean val) {
            this.writable = val;
        }
    }

    public static class Prototype {
        private OdpsType[] arguments;
        private OdpsType[] returns;

        public OdpsType[] getArguments() {
            return this.arguments;
        }

        public String getArgumentsString() {
            return this.convert2String(this.arguments);
        }

        public void setArguments(OdpsType[] arguments) {
            this.arguments = arguments;
        }

        public OdpsType[] getReturns() {
            return this.returns;
        }

        public String getReturnsString() {
            return this.convert2String(this.returns);
        }

        public void setReturns(OdpsType[] returns) {
            this.returns = returns;
        }

        private String convert2String(OdpsType[] types) {
            Object[] s = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                s[i] = types[i].name().toLowerCase();
            }
            return StringUtils.join((Object[])s, (char)',');
        }
    }

    public static class ParseError
    extends UDFException {
        public ParseError(Throwable e) {
            super(e);
        }

        public ParseError(String e) {
            super(e);
        }
    }
}

