/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.hasher;

import com.aliyun.odps.tunnel.hasher.HasherFactory;
import com.aliyun.odps.tunnel.hasher.OdpsHasher;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

class LegacyHashFactory
implements HasherFactory {
    private static Map<String, OdpsHasher> factoryMap = new HashMap<String, OdpsHasher>();

    LegacyHashFactory() {
    }

    @Override
    public OdpsHasher getHasher(String type) {
        return factoryMap.get(type);
    }

    public String getName() {
        return "legacy";
    }

    static int basicLongHasher(long val) {
        long l = val;
        l = l >> 32 ^ l;
        return (int)l;
    }

    static {
        for (HasherEntry entry : HasherEntry.values()) {
            factoryMap.put(entry.getTypeName(), entry.getHasher());
        }
    }

    private static class DecimalHasher
    implements OdpsHasher<BigDecimal> {
        private DecimalHasher() {
        }

        @Override
        public int hash(BigDecimal val) {
            throw new RuntimeException("Not supported decimal type:" + val);
        }
    }

    private static class IntervalDayTimeHasher
    implements OdpsHasher<BigDecimal> {
        private IntervalDayTimeHasher() {
        }

        @Override
        public int hash(BigDecimal val) {
            if (val == null) {
                return 0;
            }
            BigDecimal[] divideAndRemainder = val.divideAndRemainder(new BigDecimal(1).scaleByPowerOfTen(9));
            long totalSec = divideAndRemainder[0].longValue();
            int nanos = divideAndRemainder[1].intValue();
            totalSec <<= 30;
            return LegacyHashFactory.basicLongHasher(totalSec |= (long)nanos);
        }
    }

    private static class TimestampHasher
    implements OdpsHasher<Timestamp> {
        private TimestampHasher() {
        }

        @Override
        public int hash(Timestamp val) {
            if (val == null) {
                return 0;
            }
            long millis = val.getTime();
            long seconds = (millis >= 0L ? millis : millis - 999L) / 1000L;
            int nanos = val.getNanos();
            seconds <<= 30;
            return LegacyHashFactory.basicLongHasher(seconds |= (long)nanos);
        }
    }

    private static class IntervalYearMonthHasher
    extends BigintHasher {
        private IntervalYearMonthHasher() {
        }
    }

    private static class TimeHasher
    extends BigintHasher {
        private TimeHasher() {
        }
    }

    private static class DateHasher
    extends BigintHasher {
        private DateHasher() {
        }
    }

    private static class StringHasher
    implements OdpsHasher<String> {
        private static final Charset UTF8 = Charset.forName("UTF8");

        private StringHasher() {
        }

        @Override
        public int hash(String val) {
            if (val == null) {
                return 0;
            }
            byte[] chars = val.getBytes(UTF8);
            int hashVal = 0;
            for (int i = 0; i < chars.length; ++i) {
                hashVal = hashVal * 31 + chars[i];
            }
            return hashVal;
        }
    }

    private static class BooleanHasher
    implements OdpsHasher<Boolean> {
        private BooleanHasher() {
        }

        @Override
        public int hash(Boolean val) {
            if (val == null) {
                return 0;
            }
            if (val.booleanValue()) {
                return 388737479;
            }
            return -978963218;
        }
    }

    private static class DoubleHasher
    implements OdpsHasher<Double> {
        private DoubleHasher() {
        }

        @Override
        public int hash(Double val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(Double.doubleToLongBits(val));
        }
    }

    private static class FloatHasher
    implements OdpsHasher<Float> {
        private FloatHasher() {
        }

        @Override
        public int hash(Float val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(Float.floatToIntBits(val.floatValue()));
        }
    }

    private static class BigintHasher
    implements OdpsHasher<Long> {
        private BigintHasher() {
        }

        @Override
        public int hash(Long val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(val);
        }
    }

    private static class IntegerHasher
    implements OdpsHasher<Integer> {
        private IntegerHasher() {
        }

        @Override
        public int hash(Integer val) {
            if (val == null) {
                return 0;
            }
            return LegacyHashFactory.basicLongHasher(val.longValue());
        }
    }

    static enum HasherEntry {
        TINYINT("tinyint", new IntegerHasher()),
        SMALLINT("smallint", new IntegerHasher()),
        INT("int", new IntegerHasher()),
        BIGINT("bigint", new BigintHasher()),
        DATETIME("datetime", new BigintHasher()),
        DATE("date", new DateHasher()),
        INTERVALYEARMONTH("intervalyearmonth", new IntervalYearMonthHasher()),
        FLOAT("float", new FloatHasher()),
        DOUBLE("double", new DoubleHasher()),
        BOOLEAN("boolean", new BooleanHasher()),
        CHAR("char", new StringHasher()),
        VARCHAR("varchar", new StringHasher()),
        STRING("string", new StringHasher()),
        BINARY("binary", new StringHasher()),
        TIMESTAMP("timestamp", new TimestampHasher()),
        INTERVALDAYTIME("intervaldaytime", new IntervalDayTimeHasher()),
        DECIMAL("decimal", new DecimalHasher());

        String typeName;
        OdpsHasher hasher;

        private HasherEntry(String typeName, OdpsHasher hasher) {
            this.typeName = typeName;
            this.hasher = hasher;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public OdpsHasher getHasher() {
            return this.hasher;
        }
    }
}

