/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.sqa.commandapi.ArchiveCommand;
import com.aliyun.odps.sqa.commandapi.AuthorizationCommand;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CompactCommand;
import com.aliyun.odps.sqa.commandapi.DescribeInstanceCommand;
import com.aliyun.odps.sqa.commandapi.DescribeProjectCommand;
import com.aliyun.odps.sqa.commandapi.DescribeSchemaCommand;
import com.aliyun.odps.sqa.commandapi.DescribeTableCommand;
import com.aliyun.odps.sqa.commandapi.FreezeCommand;
import com.aliyun.odps.sqa.commandapi.MergeCommand;
import com.aliyun.odps.sqa.commandapi.RestoreCommand;
import com.aliyun.odps.sqa.commandapi.SQLCostCommand;
import com.aliyun.odps.sqa.commandapi.ShowCreateTableCommand;
import com.aliyun.odps.sqa.commandapi.ShowInstancesCommand;
import com.aliyun.odps.sqa.commandapi.ShowPartitionsCommand;
import com.aliyun.odps.sqa.commandapi.ShowSchemasCommand;
import com.aliyun.odps.sqa.commandapi.ShowTablesCommand;
import com.aliyun.odps.sqa.commandapi.WhoamiCommand;
import com.aliyun.odps.sqa.commandapi.antlr.command.CommandParser;
import com.aliyun.odps.sqa.commandapi.antlr.command.CommandParserBaseListener;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;

public class CommandParserListener
extends CommandParserBaseListener {
    private Command command;

    @Override
    public void exitAlterStatement(CommandParser.AlterStatementContext ctx) {
        CommandParser.AlterTableStatementSuffixContext alterCtx;
        CommandParser.TableNameContext tableNameContext = ctx.tableNamee;
        if (tableNameContext == null) {
            return;
        }
        String tableName = tableNameContext.getText();
        CommandParser.PartitionSpecContext partitionSpecContext = ctx.partition;
        String partition = "";
        if (partitionSpecContext != null) {
            partition = partitionSpecContext.getText();
        }
        if ((alterCtx = ctx.alterTableStatementSuffix()) == null) {
            return;
        }
        if (alterCtx.archive != null) {
            this.command = new ArchiveCommand(tableName, partition);
        } else if (alterCtx.merge != null) {
            this.command = new MergeCommand(tableName, partition);
        } else if (alterCtx.compact != null) {
            if (alterCtx.compact.compactTypee == null) {
                return;
            }
            String compactType = alterCtx.compact.compactTypee.getText();
            this.command = new CompactCommand(tableName, partition, compactType);
        } else if (alterCtx.freeze != null) {
            this.command = new FreezeCommand(tableName, partition);
        } else if (alterCtx.restore != null) {
            this.command = new RestoreCommand(tableName, partition);
        }
    }

    @Override
    public void exitShowTableStatement(CommandParser.ShowTableStatementContext ctx) {
        String projectName = null;
        String schemaName = null;
        String prefixName = null;
        if (ctx.project_Name != null) {
            projectName = ctx.project_Name.getText();
        }
        if (ctx.schema_Name != null) {
            schemaName = ctx.schema_Name.getText();
        }
        if (ctx.prefix_name != null) {
            prefixName = ctx.prefix_name.getText();
        }
        this.command = new ShowTablesCommand(projectName, schemaName, prefixName);
    }

    @Override
    public void exitAuthorizationStatement(CommandParser.AuthorizationStatementContext ctx) {
        this.command = new AuthorizationCommand();
    }

    @Override
    public void exitSqlCostStatement(CommandParser.SqlCostStatementContext ctx) {
        String query = null;
        if (ctx.query != null) {
            Token queryStart = ctx.query.start;
            Token queryStop = ctx.query.stop;
            Interval interval = new Interval(queryStart.getStartIndex(), queryStop.getStopIndex());
            query = queryStart.getInputStream().getText(interval);
        }
        this.command = new SQLCostCommand(query);
    }

    @Override
    public void exitShowPartitionStatement(CommandParser.ShowPartitionStatementContext ctx) {
        String projectName = null;
        String schemaName = null;
        String tableName = null;
        if (ctx.table_Name != null) {
            CommandParser.TableNameContext tableCtx = ctx.table_Name;
            if (tableCtx.db != null) {
                projectName = tableCtx.db.getText();
            }
            if (tableCtx.sch != null) {
                schemaName = tableCtx.sch.getText();
            }
            if (tableCtx.tab != null) {
                tableName = tableCtx.tab.getText();
            }
        }
        StringBuilder sb = new StringBuilder();
        if (ctx.partition_Spec != null && ctx.partition_Spec.partitions != null) {
            for (int i = 0; i < ctx.partition_Spec.partitions.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(ctx.partition_Spec.partitions.get(i).getText());
            }
        }
        String partition = sb.toString().equals("") ? null : sb.toString();
        this.command = new ShowPartitionsCommand(projectName, schemaName, tableName, partition);
    }

    @Override
    public void exitShowInstanceStatement(CommandParser.ShowInstanceStatementContext ctx) {
        String fromDate = null;
        String toDate = null;
        String number = null;
        if (ctx.from_date != null) {
            fromDate = ctx.from_date.getText();
        }
        if (ctx.to_date != null) {
            toDate = ctx.to_date.getText();
        }
        if (ctx.Num() != null) {
            number = ctx.Num().getText();
        }
        this.command = new ShowInstancesCommand(fromDate, toDate, number);
    }

    @Override
    public void exitDescTableStatement(CommandParser.DescTableStatementContext ctx) {
        String projectName = null;
        String schemaName = null;
        String tableName = null;
        if (ctx.table_Name != null) {
            CommandParser.TableNameContext tableCtx = ctx.table_Name;
            if (tableCtx.db != null) {
                projectName = tableCtx.db.getText();
            }
            if (tableCtx.sch != null) {
                schemaName = tableCtx.sch.getText();
            }
            if (tableCtx.tab != null) {
                tableName = tableCtx.tab.getText();
            }
        }
        StringBuilder sb = new StringBuilder();
        if (ctx.partition_Spec != null && ctx.partition_Spec.partitions != null) {
            for (int i = 0; i < ctx.partition_Spec.partitions.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(ctx.partition_Spec.partitions.get(i).getText());
            }
        }
        String partition = sb.toString().equals("") ? null : sb.toString();
        this.command = new DescribeTableCommand(projectName, schemaName, tableName, partition, false);
    }

    @Override
    public void exitDescTableExtendedStatement(CommandParser.DescTableExtendedStatementContext ctx) {
        String projectName = null;
        String schemaName = null;
        String tableName = null;
        if (ctx.table_Name != null) {
            CommandParser.TableNameContext tableCtx = ctx.table_Name;
            if (tableCtx.db != null) {
                projectName = tableCtx.db.getText();
            }
            if (tableCtx.sch != null) {
                schemaName = tableCtx.sch.getText();
            }
            if (tableCtx.tab != null) {
                tableName = tableCtx.tab.getText();
            }
        }
        StringBuilder sb = new StringBuilder();
        if (ctx.partition_Spec != null && ctx.partition_Spec.partitions != null) {
            for (int i = 0; i < ctx.partition_Spec.partitions.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(ctx.partition_Spec.partitions.get(i).getText());
            }
        }
        String partition = sb.toString().equals("") ? null : sb.toString();
        this.command = new DescribeTableCommand(projectName, schemaName, tableName, partition, true);
    }

    @Override
    public void exitDescProjectStatement(CommandParser.DescProjectStatementContext ctx) {
        String projectName = null;
        boolean extended = false;
        if (ctx.project_Name != null) {
            projectName = ctx.project_Name.getText();
        }
        if (ctx.KW_EXTENDED() != null) {
            extended = true;
        }
        this.command = new DescribeProjectCommand(projectName, extended);
    }

    @Override
    public void exitDescInstanceStatement(CommandParser.DescInstanceStatementContext ctx) {
        String instanceId = null;
        if (ctx.instance_Id != null) {
            instanceId = ctx.instance_Id.getText();
        }
        this.command = new DescribeInstanceCommand(instanceId);
    }

    @Override
    public void exitWhoamiStatement(CommandParser.WhoamiStatementContext ctx) {
        this.command = new WhoamiCommand();
    }

    @Override
    public void exitShowCreateTableStatement(CommandParser.ShowCreateTableStatementContext ctx) {
        this.command = new ShowCreateTableCommand();
    }

    @Override
    public void exitShowSchemasStatament(CommandParser.ShowSchemasStatamentContext ctx) {
        this.command = new ShowSchemasCommand();
    }

    @Override
    public void exitDescSchemaStatement(CommandParser.DescSchemaStatementContext ctx) {
        this.command = new DescribeSchemaCommand();
    }

    public Command getCommand() {
        return this.command;
    }
}

