/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.stream;

import com.aliyun.odps.simpleframework.xml.stream.DocumentReader;
import com.aliyun.odps.simpleframework.xml.stream.EventReader;
import com.aliyun.odps.simpleframework.xml.stream.Provider;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

class DocumentProvider
implements Provider {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public DocumentProvider() {
        this.factory.setNamespaceAware(true);
        try {
            this.factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EventReader provide(InputStream source) throws Exception {
        return this.provide(new InputSource(source));
    }

    @Override
    public EventReader provide(Reader source) throws Exception {
        return this.provide(new InputSource(source));
    }

    private EventReader provide(InputSource source) throws Exception {
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        Document document = builder.parse(source);
        return new DocumentReader(document);
    }
}

