/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TenantSecurityManager;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.RestClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Tenant
extends LazyLoad {
    private TenantModel model = new TenantModel();
    private RestClient client;

    Tenant(Odps odps) {
        this.client = odps.getRestClient();
    }

    @Override
    public void reload() throws OdpsException {
        String resource = "/tenants";
        Response response = this.client.request(resource, "GET", null, null, null);
        String json = new String(response.getBody(), StandardCharsets.UTF_8);
        this.loadFromJson(json);
    }

    public String getProperty(String key) {
        this.lazyLoad();
        return this.model.properties.get(key);
    }

    public void loadFromJson(String json) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(TenantModel.class, (Object)new TenantAdapter()).create();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        this.model = (TenantModel)gson.fromJson(jsonObject.get("Tenant"), TenantModel.class);
        this.setLoaded(true);
    }

    public TenantSecurityManager getTenantSecurityManager() {
        return new TenantSecurityManager(this.client);
    }

    static class TenantAdapter
    extends TypeAdapter<TenantModel> {
        TenantAdapter() {
        }

        public void write(JsonWriter out, TenantModel value) throws IOException {
        }

        public TenantModel read(JsonReader in) throws IOException {
            TenantModel model = new TenantModel();
            in.beginObject();
            block20: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "Name": {
                        model.name = in.nextString();
                        continue block20;
                    }
                    case "OwnerId": {
                        model.ownerId = in.nextString();
                        continue block20;
                    }
                    case "TenantId": {
                        model.tenantId = in.nextString();
                        continue block20;
                    }
                    case "State": {
                        model.tenantState = TenantState.valueOf(in.nextString().toUpperCase());
                        continue block20;
                    }
                    case "CreateTime": {
                        model.creationTime = new Date(in.nextLong());
                        continue block20;
                    }
                    case "UpdateTime": {
                        model.lastModifiedTime = new Date(in.nextLong());
                        continue block20;
                    }
                    case "TenantMeta": {
                        model.tenantProperties = in.nextString();
                        continue block20;
                    }
                    case "Parameters": {
                        in.beginObject();
                        while (in.hasNext()) {
                            String key = in.nextName();
                            String value = in.nextString();
                            model.properties.put(key, value);
                        }
                        in.endObject();
                        continue block20;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return model;
        }
    }

    static class TenantModel {
        public String name;
        public String ownerId;
        public String tenantId;
        public TenantState tenantState;
        public Date creationTime;
        public Date lastModifiedTime;
        public String tenantProperties;
        public Map<String, String> properties = new HashMap<String, String>();

        TenantModel() {
        }
    }

    public static enum TenantState {
        NORMAL,
        SUSPENDED,
        DELETING,
        DELETED;

    }
}

